/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.schedule;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.polling.schedule.FixedFrequencyScheduler;

public class FixedFrequencySchedulerTest
extends AbstractMuleContextTestCase {
    private AbstractPollingMessageReceiver receiver = (AbstractPollingMessageReceiver)Mockito.mock(AbstractPollingMessageReceiver.class);
    private Prober pollingProber = new PollingProber(1000L, 0L);

    @Test
    public void validateLifecycleHappyPath() throws MuleException {
        FixedFrequencyScheduler scheduler = this.createVoidScheduler();
        scheduler.initialise();
        scheduler.start();
        scheduler.stop();
        scheduler.dispose();
    }

    @Test
    public void stopAfterInitializeShouldNotFail() throws MuleException {
        FixedFrequencyScheduler scheduler = this.createVoidScheduler();
        scheduler.initialise();
        scheduler.stop();
    }

    @Test
    public void startAfterStopShouldNotFail() throws Exception {
        final TestPollingWorker job = new TestPollingWorker(this.receiver);
        FixedFrequencyScheduler scheduler = this.createScheduler(job);
        scheduler.initialise();
        scheduler.start();
        scheduler.stop();
        scheduler.start();
        Assert.assertFalse((boolean)job.wasRun);
        scheduler.schedule();
        this.pollingProber.check(new Probe(){

            @Override
            public boolean isSatisfied() {
                return job.wasRun;
            }

            @Override
            public String describeFailure() {
                return "The scheduler was never run";
            }
        });
        scheduler.stop();
    }

    private FixedFrequencyScheduler createVoidScheduler() {
        return new FixedFrequencyScheduler("name", 10L, 50L, (Runnable)new PollingReceiverWorker(this.receiver), TimeUnit.HOURS);
    }

    private FixedFrequencyScheduler createScheduler(PollingReceiverWorker job) {
        return new FixedFrequencyScheduler("name", 10L, 50L, (Runnable)job, TimeUnit.HOURS);
    }

    private class TestPollingWorker
    extends PollingReceiverWorker {
        boolean wasRun;

        public TestPollingWorker(AbstractPollingMessageReceiver pollingMessageReceiver) {
            super(pollingMessageReceiver);
        }

        public void run() {
            this.wasRun = true;
        }
    }
}

