/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.SerializationUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.CopyOnWriteCaseInsensitiveMap;

@SmallTest
public class CopyOnWriteCaseInsensitiveMapTestCase
extends AbstractMuleTestCase {
    private static final String KEY1 = "FOO";
    private static final String KEY2 = "doo";

    @Test
    public void caseInsensitive() throws Exception {
        this.assertMapContents((Map<String, Object>)this.createTestMap());
    }

    @Test
    public void keysCaseSensitive() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> map = this.createTestMap();
        Assert.assertEquals((long)2L, (long)map.keySet().size());
        Assert.assertTrue((map.keySet().toArray()[0].equals(KEY1) || map.keySet().toArray()[0].equals(KEY2) ? 1 : 0) != 0);
        Assert.assertTrue((map.keySet().toArray()[1].equals(KEY1) || map.keySet().toArray()[1].equals(KEY2) ? 1 : 0) != 0);
    }

    @Test
    public void caseInsensitiveDelegate() throws Exception {
        this.assertMapContents((Map<String, Object>)this.createTestMap().clone());
    }

    @Test
    public void caseInsensitiveCopiedDelegate() throws Exception {
        CopyOnWriteCaseInsensitiveMap map = this.createTestMap().clone();
        map.put("new", "val");
        this.assertMapContents((Map<String, Object>)map);
    }

    @Test
    public void serialize() throws Exception {
        this.assertMapContents(this.serializeAndDeserialize((Map<String, Object>)this.createTestMap()));
    }

    @Test
    public void serializeDelegate() throws Exception {
        this.assertMapContents(this.serializeAndDeserialize((Map<String, Object>)this.createTestMap().clone()));
    }

    @Test
    public void serializeCopiedDelegate() throws Exception {
        CopyOnWriteCaseInsensitiveMap map = this.createTestMap().clone();
        map.put("new", "val");
        this.assertMapContents(this.serializeAndDeserialize((Map<String, Object>)map));
    }

    protected Map<String, Object> serializeAndDeserialize(Map<String, Object> map) {
        byte[] bytes = SerializationUtils.serialize((Serializable)((Serializable)((Object)map)));
        return (Map)SerializationUtils.deserialize((byte[])bytes);
    }

    protected void assertMapContents(Map<String, Object> map) {
        Assert.assertEquals((Object)"BAR", (Object)map.get(KEY1));
        Assert.assertEquals((Object)"BAR", (Object)map.get("foo"));
        Assert.assertEquals((Object)"BAR", (Object)map.get("Foo"));
        Assert.assertEquals((Object)3, (Object)map.get("DOO"));
        Assert.assertEquals((Object)3, (Object)map.get(KEY2));
        Assert.assertEquals((Object)3, (Object)map.get("Doo"));
    }

    protected CopyOnWriteCaseInsensitiveMap<String, Object> createTestMap() {
        CopyOnWriteCaseInsensitiveMap map = new CopyOnWriteCaseInsensitiveMap();
        map.put((Object)KEY1, (Object)"BAR");
        map.put((Object)KEY2, (Object)3);
        return map;
    }

    @Test
    public void entrySet() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        Assert.assertEquals((long)2L, (long)original.size());
        original.keySet().remove(KEY1);
        Assert.assertEquals((long)1L, (long)original.size());
        original.keySet().clear();
        Assert.assertEquals((long)0L, (long)original.size());
    }

    @Test
    public void entrySetCloneMutateOriginal() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        CopyOnWriteCaseInsensitiveMap copyOnWriteMap = original.clone();
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
        original.keySet().remove(KEY1);
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
        original.keySet().clear();
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
    }

    @Test
    public void entrySetCloneMutateClone() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        CopyOnWriteCaseInsensitiveMap copyOnWriteMap = original.clone();
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
        copyOnWriteMap.keySet().remove(KEY1);
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)1L, (long)copyOnWriteMap.size());
        copyOnWriteMap.keySet().clear();
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)0L, (long)copyOnWriteMap.size());
    }

    @Test
    public void putClone() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        CopyOnWriteCaseInsensitiveMap copyOnWriteMap = original.clone();
        original.put((Object)"newOriginal", (Object)"val");
        copyOnWriteMap.put("newCopy", "val");
        this.assertMapContents((Map<String, Object>)original);
        Assert.assertEquals((long)3L, (long)original.size());
        Assert.assertFalse((boolean)original.containsKey((Object)"newCopy"));
        Assert.assertTrue((boolean)original.containsKey((Object)"newOriginal"));
        this.assertMapContents((Map<String, Object>)copyOnWriteMap);
        Assert.assertEquals((long)3L, (long)copyOnWriteMap.size());
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("newCopy"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("newOriginal"));
    }

    @Test
    public void putAllClone() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        CopyOnWriteCaseInsensitiveMap copyOnWriteMap = original.clone();
        HashMap<String, String> newOriginalEntriesMap = new HashMap<String, String>();
        newOriginalEntriesMap.put("newOriginal1", "val");
        newOriginalEntriesMap.put("newOriginal2", "val");
        newOriginalEntriesMap.put("newOriginal3", "val");
        original.putAll(newOriginalEntriesMap);
        HashMap<String, String> newCopyEntriesMap = new HashMap<String, String>();
        newCopyEntriesMap.put("newCopy1", "val");
        newCopyEntriesMap.put("newCopy2", "val");
        newCopyEntriesMap.put("newCopy3", "val");
        copyOnWriteMap.putAll(newCopyEntriesMap);
        this.assertMapContents((Map<String, Object>)original);
        Assert.assertEquals((long)5L, (long)original.size());
        Assert.assertTrue((boolean)original.containsKey((Object)"newOriginal1"));
        Assert.assertTrue((boolean)original.containsKey((Object)"newOriginal2"));
        Assert.assertTrue((boolean)original.containsKey((Object)"newOriginal3"));
        Assert.assertFalse((boolean)original.containsKey((Object)"newCopy1"));
        Assert.assertFalse((boolean)original.containsKey((Object)"newCopy2"));
        Assert.assertFalse((boolean)original.containsKey((Object)"newCopy3"));
        this.assertMapContents((Map<String, Object>)copyOnWriteMap);
        Assert.assertEquals((long)5L, (long)copyOnWriteMap.size());
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("newCopy1"));
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("newCopy2"));
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("newCopy3"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("newOriginal1"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("newOriginal2"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("newOriginal3"));
    }

    @Test
    public void removeClone() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        original.put((Object)"extra", (Object)"value");
        original.put((Object)"extra2", (Object)"value");
        CopyOnWriteCaseInsensitiveMap copyOnWriteMap = original.clone();
        original.remove((Object)"extra");
        copyOnWriteMap.remove("extra2");
        this.assertMapContents((Map<String, Object>)original);
        Assert.assertEquals((long)3L, (long)original.size());
        Assert.assertFalse((boolean)original.containsKey((Object)"extra"));
        Assert.assertTrue((boolean)original.containsKey((Object)"extra2"));
        this.assertMapContents((Map<String, Object>)copyOnWriteMap);
        Assert.assertEquals((long)3L, (long)copyOnWriteMap.size());
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("extra"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("extra2"));
    }

    @Test
    public void clearOrignalClone() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        CopyOnWriteCaseInsensitiveMap copyOnWriteMap = original.clone();
        original.clear();
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertEquals((long)0L, (long)original.entrySet().size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.entrySet().size());
    }

    @Test
    public void clearCopyClone() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        CopyOnWriteCaseInsensitiveMap copyOnWriteMap = original.clone();
        copyOnWriteMap.clear();
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)2L, (long)original.entrySet().size());
        Assert.assertEquals((long)0L, (long)copyOnWriteMap.size());
        Assert.assertEquals((long)0L, (long)copyOnWriteMap.entrySet().size());
    }

    @Test
    public void entrySetDeserializedMutateOriginal() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        Map<String, Object> copyOnWriteMap = this.serializeAndDeserialize((Map<String, Object>)original);
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
        original.keySet().remove(KEY1);
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
        original.keySet().clear();
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
    }

    @Test
    public void entrySetDeserializedMutateClone() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        Map<String, Object> copyOnWriteMap = this.serializeAndDeserialize((Map<String, Object>)original);
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
        copyOnWriteMap.keySet().remove(KEY1);
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)1L, (long)copyOnWriteMap.size());
        copyOnWriteMap.keySet().clear();
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)0L, (long)copyOnWriteMap.size());
    }

    @Test
    public void putDeserialized() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        Map<String, Object> copyOnWriteMap = this.serializeAndDeserialize((Map<String, Object>)original);
        original.put((Object)"newOriginal", (Object)"val");
        copyOnWriteMap.put("newCopy", "val");
        this.assertMapContents((Map<String, Object>)original);
        Assert.assertEquals((long)3L, (long)original.size());
        Assert.assertFalse((boolean)original.containsKey((Object)"newCopy"));
        Assert.assertTrue((boolean)original.containsKey((Object)"newOriginal"));
        this.assertMapContents(copyOnWriteMap);
        Assert.assertEquals((long)3L, (long)copyOnWriteMap.size());
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("newCopy"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("newOriginal"));
    }

    @Test
    public void putAllDeserialized() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        Map<String, Object> copyOnWriteMap = this.serializeAndDeserialize((Map<String, Object>)original);
        HashMap<String, String> newOriginalEntriesMap = new HashMap<String, String>();
        newOriginalEntriesMap.put("newOriginal1", "val");
        newOriginalEntriesMap.put("newOriginal2", "val");
        newOriginalEntriesMap.put("newOriginal3", "val");
        original.putAll(newOriginalEntriesMap);
        HashMap<String, String> newCopyEntriesMap = new HashMap<String, String>();
        newCopyEntriesMap.put("newCopy1", "val");
        newCopyEntriesMap.put("newCopy2", "val");
        newCopyEntriesMap.put("newCopy3", "val");
        copyOnWriteMap.putAll(newCopyEntriesMap);
        this.assertMapContents((Map<String, Object>)original);
        Assert.assertEquals((long)5L, (long)original.size());
        Assert.assertTrue((boolean)original.containsKey((Object)"newOriginal1"));
        Assert.assertTrue((boolean)original.containsKey((Object)"newOriginal2"));
        Assert.assertTrue((boolean)original.containsKey((Object)"newOriginal3"));
        Assert.assertFalse((boolean)original.containsKey((Object)"newCopy1"));
        Assert.assertFalse((boolean)original.containsKey((Object)"newCopy2"));
        Assert.assertFalse((boolean)original.containsKey((Object)"newCopy3"));
        this.assertMapContents(copyOnWriteMap);
        Assert.assertEquals((long)5L, (long)copyOnWriteMap.size());
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("newCopy1"));
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("newCopy2"));
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("newCopy3"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("newOriginal1"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("newOriginal2"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("newOriginal3"));
    }

    @Test
    public void removeDeserialized() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        original.put((Object)"extra", (Object)"value");
        original.put((Object)"extra2", (Object)"value");
        Map<String, Object> copyOnWriteMap = this.serializeAndDeserialize((Map<String, Object>)original);
        original.remove((Object)"extra");
        copyOnWriteMap.remove("extra2");
        this.assertMapContents((Map<String, Object>)original);
        Assert.assertEquals((long)3L, (long)original.size());
        Assert.assertFalse((boolean)original.containsKey((Object)"extra"));
        Assert.assertTrue((boolean)original.containsKey((Object)"extra2"));
        this.assertMapContents(copyOnWriteMap);
        Assert.assertEquals((long)3L, (long)copyOnWriteMap.size());
        Assert.assertTrue((boolean)copyOnWriteMap.containsKey("extra"));
        Assert.assertFalse((boolean)copyOnWriteMap.containsKey("extra2"));
    }

    @Test
    public void clearOrignalDeserialized() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        Map<String, Object> copyOnWriteMap = this.serializeAndDeserialize((Map<String, Object>)original);
        original.clear();
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertEquals((long)0L, (long)original.entrySet().size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.size());
        Assert.assertEquals((long)2L, (long)copyOnWriteMap.entrySet().size());
    }

    @Test
    public void clearCopyDeserialized() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> original = this.createTestMap();
        Map<String, Object> copyOnWriteMap = this.serializeAndDeserialize((Map<String, Object>)original);
        copyOnWriteMap.clear();
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertEquals((long)2L, (long)original.entrySet().size());
        Assert.assertEquals((long)0L, (long)copyOnWriteMap.size());
        Assert.assertEquals((long)0L, (long)copyOnWriteMap.entrySet().size());
    }

    @Test
    public void keySetGivesAllKeys() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> map = this.createTestMap();
        HashSet<String> foundKeys = new HashSet<String>();
        for (String key : map.keySet()) {
            Assert.assertTrue((KEY1.equals(key) || KEY2.equals(key) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)foundKeys.contains(key));
            foundKeys.add(key);
        }
    }

    @Test
    public void removeKeySetItem() throws Exception {
        CopyOnWriteCaseInsensitiveMap<String, Object> map = this.createTestMap();
        Iterator it = map.keySet().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        String key = (String)it.next();
        it.remove();
        Assert.assertFalse((boolean)map.keySet().contains(key));
        it = map.keySet().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        String key2 = (String)it.next();
        Assert.assertFalse((boolean)key.equals(key2));
        Assert.assertFalse((boolean)it.hasNext());
        it.remove();
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertTrue((boolean)map.keySet().isEmpty());
        it = map.keySet().iterator();
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            junit.framework.Assert.fail((String)"Was expecting NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    @Test(expected=NoSuchElementException.class)
    public void emptyMapKeySetIterator() throws Exception {
        CopyOnWriteCaseInsensitiveMap map = new CopyOnWriteCaseInsensitiveMap();
        Assert.assertTrue((boolean)map.keySet().isEmpty());
        Iterator iterator = map.keySet().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.next();
    }

    @Test(expected=IllegalStateException.class)
    public void removeInKeySetIteratorBeforeAnyNext() throws Exception {
        this.createTestMap().keySet().iterator().remove();
    }

    @Test(expected=IllegalStateException.class)
    public void keySetIteratorWithTwoRemovesInTheSameNext() throws Exception {
        Iterator iterator = this.createTestMap().keySet().iterator();
        iterator.next();
        iterator.remove();
        iterator.remove();
    }

    @Test
    public void removeShouldNotMoveForward() throws Exception {
        String key2;
        CopyOnWriteCaseInsensitiveMap<String, Object> map = this.createTestMap();
        String EXTRA_KEY = "THIRD";
        map.put((Object)"THIRD", new Object());
        ArrayList<String> keys = new ArrayList<String>();
        for (String key2 : map.keySet()) {
            keys.add(key2);
        }
        Iterator iterator = map.keySet().iterator();
        iterator.next();
        iterator.next();
        iterator.remove();
        key2 = (String)iterator.next();
        Assert.assertEquals(keys.get(2), (Object)key2);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void asHashMap() {
        CopyOnWriteCaseInsensitiveMap<String, Object> map = this.createTestMap();
        Map regularMap = map.asHashMap();
        Assert.assertThat((Object)regularMap, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HashMap.class)));
        Assert.assertThat((Object)regularMap.size(), (Matcher)CoreMatchers.is((Object)map.size()));
        for (Map.Entry entry : map.entrySet()) {
            Assert.assertThat((Object)map.get(entry.getKey()), (Matcher)CoreMatchers.is(regularMap.get(entry.getKey())));
        }
    }
}

