/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.queue.QueueControlDataFile;
import org.mule.util.queue.QueueFileProvider;

@SmallTest
public class QueueControlDataFileTestCase
extends AbstractMuleTestCase {
    private static final File DEFAULT_QUEUE_FILE = new File("default-queue-file-path");
    private static final String QUEUE_CONTROL_DATA_FILE_NAME = "queue-data";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void withNoQueueDataThenUseDefaultFile() {
        QueueControlDataFile queueControlDataFile = this.createTestQueueDataControl();
        Assert.assertThat((Object)queueControlDataFile.getCurrentWriteFile().getAbsolutePath(), (Matcher)Is.is((Object)DEFAULT_QUEUE_FILE.getAbsolutePath()));
        Assert.assertThat((Object)queueControlDataFile.getCurrentReadFile().getAbsolutePath(), (Matcher)Is.is((Object)DEFAULT_QUEUE_FILE.getAbsolutePath()));
        queueControlDataFile.close();
    }

    @Test
    public void queueDataWithPrexistentControlData() {
        QueueControlDataFile previousQueueControlDataFile = this.createTestQueueDataControl();
        String writeFilePath = "test-write-file";
        String readFilePath = "test-read-file";
        previousQueueControlDataFile.writeControlData(new File("test-write-file"), new File("test-read-file"));
        previousQueueControlDataFile.close();
        QueueControlDataFile newQueueControlDataFile = this.createTestQueueDataControl();
        Assert.assertThat((Object)newQueueControlDataFile.getCurrentReadFile().getAbsolutePath(), (Matcher)Is.is((Object)previousQueueControlDataFile.getCurrentReadFile().getAbsolutePath()));
        Assert.assertThat((Object)newQueueControlDataFile.getCurrentWriteFile().getAbsolutePath(), (Matcher)Is.is((Object)previousQueueControlDataFile.getCurrentWriteFile().getAbsolutePath()));
        newQueueControlDataFile.close();
    }

    @Test
    public void queueDataFileDoesNotGrow() {
        QueueControlDataFile queueControlDataFile = this.createTestQueueDataControl();
        queueControlDataFile.writeControlData(DEFAULT_QUEUE_FILE, DEFAULT_QUEUE_FILE);
        long initalSize = this.getTestQueueDataControlFile().length();
        queueControlDataFile.writeControlData(DEFAULT_QUEUE_FILE, DEFAULT_QUEUE_FILE);
        Assert.assertThat((Object)this.getTestQueueDataControlFile().length(), (Matcher)Is.is((Object)initalSize));
    }

    private QueueControlDataFile createTestQueueDataControl() {
        return new QueueControlDataFile(new QueueFileProvider(this.getTestQueueDataControlFile().getParentFile(), this.getTestQueueDataControlFile().getName()), DEFAULT_QUEUE_FILE, DEFAULT_QUEUE_FILE);
    }

    private File getTestQueueDataControlFile() {
        return new File(this.temporaryFolder.getRoot(), QUEUE_CONTROL_DATA_FILE_NAME);
    }
}

