/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointCache;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;

public class SimpleEndpointCache
implements EndpointCache {
    protected MuleContext muleContext;
    private ConcurrentMap<String, InboundEndpoint> inboundEndpointCache = new ConcurrentHashMap<String, InboundEndpoint>();
    private ConcurrentMap<String, OutboundEndpoint> outboundEndpointCache = new ConcurrentHashMap<String, OutboundEndpoint>();

    public SimpleEndpointCache(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public OutboundEndpoint getOutboundEndpoint(String uri, MessageExchangePattern mep, Long responseTimeout) throws MuleException {
        String key = uri + ":" + mep.toString() + ":" + responseTimeout;
        OutboundEndpoint endpoint = (OutboundEndpoint)this.outboundEndpointCache.get(key);
        if (endpoint == null) {
            OutboundEndpoint concurrentlyAddedEndpoint;
            EndpointBuilder endpointBuilder = this.muleContext.getEndpointFactory().getEndpointBuilder(uri);
            endpointBuilder.setExchangePattern(mep);
            if (responseTimeout != null && responseTimeout > 0L) {
                endpointBuilder.setResponseTimeout(responseTimeout.intValue());
            }
            if ((concurrentlyAddedEndpoint = this.outboundEndpointCache.putIfAbsent(key, endpoint = this.muleContext.getEndpointFactory().getOutboundEndpoint(endpointBuilder))) != null) {
                return concurrentlyAddedEndpoint;
            }
        }
        return endpoint;
    }

    @Override
    public InboundEndpoint getInboundEndpoint(String uri, MessageExchangePattern mep) throws MuleException {
        String key = uri + ":" + mep.toString();
        InboundEndpoint endpoint = (InboundEndpoint)this.inboundEndpointCache.get(key);
        if (endpoint == null) {
            EndpointBuilder endpointBuilder = this.muleContext.getEndpointFactory().getEndpointBuilder(uri);
            endpointBuilder.setExchangePattern(mep);
            endpoint = this.muleContext.getEndpointFactory().getInboundEndpoint(endpointBuilder);
            InboundEndpoint concurrentlyAddedEndpoint = this.inboundEndpointCache.putIfAbsent(key, endpoint);
            if (concurrentlyAddedEndpoint != null) {
                return concurrentlyAddedEndpoint;
            }
        }
        return endpoint;
    }
}

