/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.ObjectUtils;

public class InboundEndpointMimeTypeCheckingMessageProcessor
implements MessageProcessor {
    private InboundEndpoint endpoint;

    public InboundEndpointMimeTypeCheckingMessageProcessor(InboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MessagingException {
        String endpointMimeType = this.endpoint.getMimeType();
        if (endpointMimeType != null) {
            MuleMessage message = event.getMessage();
            String contentType = (String)message.getProperty("Content-Type", PropertyScope.INBOUND);
            if (contentType == null) {
                contentType = (String)message.getProperty("Content-Type", PropertyScope.OUTBOUND);
            }
            if (contentType == null) {
                message.setProperty("Content-Type", endpointMimeType, PropertyScope.INBOUND);
            } else {
                try {
                    MimeType mt = new MimeType(contentType);
                    String messageMimeType = mt.getPrimaryType() + "/" + mt.getSubType();
                    if (!messageMimeType.equals(endpointMimeType)) {
                        throw new MessagingException(CoreMessages.unexpectedMIMEType(messageMimeType, endpointMimeType), event, (MessageProcessor)this);
                    }
                }
                catch (MimeTypeParseException ex) {
                    throw new MessagingException(CoreMessages.illegalMIMEType(contentType), event, ex, this);
                }
            }
        }
        return event;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }
}

