/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.mule.DefaultMuleEvent;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.MessageProcessorPathResolver;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.ReplyToHandler;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.execution.MessageProcessorExecutionInterceptor;
import org.mule.processor.NonBlockingMessageProcessor;

class MessageProcessorNotificationExecutionInterceptor
implements MessageProcessorExecutionInterceptor {
    private MessageProcessorExecutionInterceptor next;

    MessageProcessorNotificationExecutionInterceptor(MessageProcessorExecutionInterceptor next) {
        this.next = next;
    }

    MessageProcessorNotificationExecutionInterceptor() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MuleEvent execute(final MessageProcessor messageProcessor, final MuleEvent event) throws MessagingException {
        boolean responseProcessing;
        final ServerNotificationManager notificationManager = event.getMuleContext().getNotificationManager();
        final boolean fireNotification = event.isNotificationsEnabled();
        if (fireNotification) {
            this.fireNotification(notificationManager, event.getFlowConstruct(), event, messageProcessor, null, 1601);
        }
        MuleEvent eventToProcess = event;
        MuleEvent result = null;
        MessagingException exceptionThrown = null;
        boolean nonBlocking = event.isAllowNonBlocking() && event.getReplyToHandler() != null;
        boolean bl = responseProcessing = messageProcessor instanceof InterceptingMessageProcessor || messageProcessor instanceof NonBlockingMessageProcessor;
        if (nonBlocking && responseProcessing) {
            final ReplyToHandler originalReplyToHandler = event.getReplyToHandler();
            eventToProcess = new DefaultMuleEvent(event, new ReplyToHandler(){

                @Override
                public void processReplyTo(MuleEvent result, MuleMessage returnMessage, Object replyTo) throws MuleException {
                    if (fireNotification) {
                        MessageProcessorNotificationExecutionInterceptor.this.fireNotification(notificationManager, event.getFlowConstruct(), result != null ? result : event, messageProcessor, null, 1602);
                    }
                    originalReplyToHandler.processReplyTo(result, returnMessage, replyTo);
                }

                @Override
                public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
                    if (fireNotification) {
                        MuleEvent result = exception.getEvent();
                        MessageProcessorNotificationExecutionInterceptor.this.fireNotification(notificationManager, event.getFlowConstruct(), result != null ? result : event, messageProcessor, null, 1602);
                    }
                    originalReplyToHandler.processExceptionReplyTo(exception, replyTo);
                }
            });
            OptimizedRequestContext.unsafeSetEvent(eventToProcess);
        }
        try {
            result = this.next == null ? messageProcessor.process(eventToProcess) : this.next.execute(messageProcessor, eventToProcess);
            if (NonBlockingVoidMuleEvent.getInstance().equals(result)) return result;
            if (!fireNotification) return result;
            this.fireNotification(notificationManager, event.getFlowConstruct(), result != null ? result : event, messageProcessor, exceptionThrown, 1602);
            return result;
        }
        catch (MessagingException e) {
            try {
                exceptionThrown = e;
                throw e;
                catch (MuleException e2) {
                    exceptionThrown = new MessagingException(event, e2, messageProcessor);
                    throw exceptionThrown;
                }
            }
            catch (Throwable throwable) {
                if (NonBlockingVoidMuleEvent.getInstance().equals(result)) throw throwable;
                if (!fireNotification) throw throwable;
                this.fireNotification(notificationManager, event.getFlowConstruct(), result != null ? result : event, messageProcessor, exceptionThrown, 1602);
                throw throwable;
            }
        }
    }

    protected void fireNotification(ServerNotificationManager serverNotificationManager, FlowConstruct flowConstruct, MuleEvent event, MessageProcessor processor, MessagingException exceptionThrown, int action) {
        if (serverNotificationManager != null && serverNotificationManager.isNotificationEnabled(MessageProcessorNotification.class) && flowConstruct instanceof MessageProcessorPathResolver && ((MessageProcessorPathResolver)((Object)flowConstruct)).getProcessorPath(processor) != null) {
            serverNotificationManager.fireNotification(new MessageProcessorNotification(flowConstruct, event, processor, exceptionThrown, action));
        }
    }
}

