/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.execution.AsyncResponseFlowProcessingPhase;
import org.mule.execution.EndProcessPhase;
import org.mule.execution.FlowProcessingPhase;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.MessageProcessTemplate;
import org.mule.execution.MessageProcessingManager;
import org.mule.execution.PhaseExecutionEngine;
import org.mule.execution.ValidationPhase;

public class MuleMessageProcessingManager
implements MessageProcessingManager,
MuleContextAware,
Initialisable {
    private final EndProcessPhase endProcessPhase = new EndProcessPhase();
    private MuleContext muleContext;
    private PhaseExecutionEngine phaseExecutionEngine;

    @Override
    public void processMessage(MessageProcessTemplate messageProcessTemplate, MessageProcessContext messageProcessContext) {
        this.phaseExecutionEngine.process(messageProcessTemplate, messageProcessContext);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        Collection<MessageProcessPhase> registryMessageProcessPhases = this.muleContext.getRegistry().lookupObjects(MessageProcessPhase.class);
        ArrayList<MessageProcessPhase> messageProcessPhaseList = new ArrayList<MessageProcessPhase>();
        if (registryMessageProcessPhases != null) {
            messageProcessPhaseList.addAll(registryMessageProcessPhases);
        }
        messageProcessPhaseList.add(new ValidationPhase());
        messageProcessPhaseList.add(new FlowProcessingPhase());
        messageProcessPhaseList.add(new AsyncResponseFlowProcessingPhase());
        Collections.sort(messageProcessPhaseList, new Comparator<MessageProcessPhase>(){

            @Override
            public int compare(MessageProcessPhase messageProcessPhase, MessageProcessPhase messageProcessPhase2) {
                int compareValue = 0;
                if (messageProcessPhase instanceof Comparable) {
                    compareValue = ((Comparable)((Object)messageProcessPhase)).compareTo(messageProcessPhase2);
                }
                if (compareValue == 0 && messageProcessPhase2 instanceof Comparable) {
                    compareValue = ((Comparable)((Object)messageProcessPhase2)).compareTo(messageProcessPhase) * -1;
                }
                return compareValue;
            }
        });
        this.phaseExecutionEngine = new PhaseExecutionEngine(messageProcessPhaseList, this.muleContext.getExceptionListener(), this.endProcessPhase);
    }
}

