/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.mule.api.MuleMessage;

public class InboundAttachmentsMap
implements Map<String, DataHandler> {
    private MuleMessage message;

    public InboundAttachmentsMap(MuleMessage message) {
        this.message = message;
    }

    @Override
    public int size() {
        return this.message.getInboundAttachmentNames().size();
    }

    @Override
    public boolean isEmpty() {
        return this.message.getInboundAttachmentNames().size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.message.getInboundAttachmentNames().contains(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public DataHandler get(Object key) {
        return this.message.getInboundAttachment(key.toString());
    }

    @Override
    public DataHandler put(String key, DataHandler value) {
        throw new UnsupportedOperationException("put(): Inbound attachments are read-only");
    }

    @Override
    public DataHandler remove(Object key) {
        throw new UnsupportedOperationException("remove(): Inbound attachments are read-only");
    }

    @Override
    public void putAll(Map<? extends String, ? extends DataHandler> map) {
        for (Map.Entry<? extends String, ? extends DataHandler> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public Set<String> keySet() {
        return this.message.getInboundAttachmentNames();
    }

    @Override
    public Collection<DataHandler> values() {
        return this.getAttachments().values();
    }

    @Override
    public Set<Map.Entry<String, DataHandler>> entrySet() {
        return this.getAttachments().entrySet();
    }

    private Map<String, DataHandler> getAttachments() {
        HashMap<String, DataHandler> props = new HashMap<String, DataHandler>();
        for (String s : this.message.getInboundAttachmentNames()) {
            props.put(s, this.message.getInboundAttachment(s));
        }
        return props;
    }
}

