/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.notification.ClusterNodeNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.LifecycleStateEnabled;
import org.mule.api.lifecycle.Startable;
import org.mule.context.notification.NotificationException;

public class PrimaryNodeLifecycleNotificationListener
implements ClusterNodeNotificationListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private Startable startMeOnPrimaryNodeNotification;
    private MuleContext muleContext;

    public PrimaryNodeLifecycleNotificationListener(Startable startMeOnPrimaryNodeNotification, MuleContext muleContext) {
        this.startMeOnPrimaryNodeNotification = startMeOnPrimaryNodeNotification;
        this.muleContext = muleContext;
    }

    public void register() {
        try {
            if (this.muleContext != null) {
                this.muleContext.registerListener(this);
            }
        }
        catch (NotificationException e) {
            throw new RuntimeException("Unable to register listener", e);
        }
    }

    @Override
    public void onNotification(ServerNotification notification) {
        try {
            if (this.startMeOnPrimaryNodeNotification instanceof LifecycleState) {
                if (((LifecycleState)((Object)this.startMeOnPrimaryNodeNotification)).isStarted()) {
                    this.startMeOnPrimaryNodeNotification.start();
                } else {
                    this.logStartableNotStartedMessage();
                }
            } else if (this.startMeOnPrimaryNodeNotification instanceof LifecycleStateEnabled) {
                if (((LifecycleStateEnabled)((Object)this.startMeOnPrimaryNodeNotification)).getLifecycleState().isStarted()) {
                    this.startMeOnPrimaryNodeNotification.start();
                } else {
                    this.logStartableNotStartedMessage();
                }
            } else {
                this.startMeOnPrimaryNodeNotification.start();
            }
        }
        catch (MuleException e) {
            throw new RuntimeException("Error starting wrapped message source", e);
        }
    }

    private void logStartableNotStartedMessage() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Not starting Startable since it's not in started state");
        }
    }

    public void unregister() {
        this.muleContext.unregisterListener(this);
    }
}

