/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecyclePhase;
import org.mule.api.registry.Registry;
import org.mule.lifecycle.LifecycleObject;
import org.mule.lifecycle.RegistryLifecycleManager;
import org.mule.lifecycle.phases.ContainerManagedLifecyclePhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryLifecycleCallback<T>
implements LifecycleCallback<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryLifecycleCallback.class);
    protected final RegistryLifecycleManager registryLifecycleManager;

    public RegistryLifecycleCallback(RegistryLifecycleManager registryLifecycleManager) {
        this.registryLifecycleManager = registryLifecycleManager;
    }

    @Override
    public void onTransition(String phaseName, T object) throws MuleException {
        LifecyclePhase phase = this.registryLifecycleManager.phases.get(phaseName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Applying lifecycle phase: %s for registry: %s", phase, object.getClass().getSimpleName()));
        }
        if (phase instanceof ContainerManagedLifecyclePhase) {
            phase.applyLifecycle(object);
            return;
        }
        HashSet<Object> duplicates = new HashSet<Object>();
        for (LifecycleObject lifecycleObject : phase.getOrderedLifecycleObjects()) {
            lifecycleObject.firePreNotification(this.registryLifecycleManager.muleContext);
            Collection<?> targetsObj = this.lookupObjectsForLifecycle(lifecycleObject);
            this.doApplyLifecycle(phase, duplicates, lifecycleObject, targetsObj);
            lifecycleObject.firePostNotification(this.registryLifecycleManager.muleContext);
        }
    }

    private void doApplyLifecycle(LifecyclePhase phase, Set<Object> duplicates, LifecycleObject lifecycleObject, Collection<?> targetObjects) throws LifecycleException {
        if (CollectionUtils.isEmpty(targetObjects)) {
            return;
        }
        for (Object target : targetObjects) {
            if (duplicates.contains(target)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("lifecycle phase: " + phase.getName() + " for object: " + target);
            }
            phase.applyLifecycle(target);
            duplicates.add(target);
        }
        int originalTargetCount = targetObjects.size();
        targetObjects = this.lookupObjectsForLifecycle(lifecycleObject);
        if (targetObjects.size() > originalTargetCount) {
            this.doApplyLifecycle(phase, duplicates, lifecycleObject, targetObjects);
        }
    }

    protected Collection<?> lookupObjectsForLifecycle(LifecycleObject lo) {
        return ((Registry)this.registryLifecycleManager.getLifecycleObject()).lookupObjectsForLifecycle(lo.getType());
    }
}

