/*
 * Decompiled with CFR 0.152.
 */
package org.mule.retry.policies;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.retry.RetryPolicy;
import org.mule.retry.PolicyStatus;

public class SimpleRetryPolicy
implements RetryPolicy {
    protected static final Log logger = LogFactory.getLog(SimpleRetryPolicy.class);
    protected RetryCounter retryCounter;
    private volatile int count = 2;
    private volatile long frequency = 2000L;

    public SimpleRetryPolicy(long frequency, int retryCount) {
        this.frequency = frequency;
        this.count = retryCount;
        this.retryCounter = new RetryCounter();
    }

    @Override
    public PolicyStatus applyPolicy(Throwable cause) {
        if (this.isExhausted() || !this.isApplicableTo(cause)) {
            return PolicyStatus.policyExhausted(cause);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Waiting for " + this.frequency + "ms before reconnecting. Failed attempt " + (this.retryCounter.current().get() + 1) + " of " + (this.count != -1 ? String.valueOf(this.count) : "unlimited")));
        }
        try {
            this.retryCounter.current().getAndIncrement();
            Thread.sleep(this.frequency);
            return PolicyStatus.policyOk();
        }
        catch (InterruptedException e) {
            return PolicyStatus.policyExhausted(e);
        }
    }

    protected boolean isApplicableTo(Throwable cause) {
        return true;
    }

    protected boolean isExhausted() {
        return this.count != -1 && this.retryCounter.current().get() >= this.count;
    }

    protected static class RetryCounter
    extends ThreadLocal<AtomicInteger> {
        protected RetryCounter() {
        }

        public int countRetry() {
            return ((AtomicInteger)this.get()).incrementAndGet();
        }

        public void reset() {
            ((AtomicInteger)this.get()).set(0);
        }

        public AtomicInteger current() {
            return (AtomicInteger)this.get();
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    }
}

