/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Collections;
import java.util.Map;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;

public class CompositeRoutingException
extends MessagingException {
    private static final long serialVersionUID = -4421728527040579607L;
    private final Map<Integer, Throwable> exceptions;

    public CompositeRoutingException(Message message, MuleEvent event, Map<Integer, Throwable> exceptions) {
        super(message, event);
        this.exceptions = Collections.unmodifiableMap(exceptions);
    }

    public CompositeRoutingException(MuleEvent event, Map<Integer, Throwable> exceptions) {
        this(CompositeRoutingException.buildExceptionMessage(exceptions), event, exceptions);
    }

    public Throwable getExceptionForRouteIndex(Integer index) {
        return this.exceptions.get(index);
    }

    public Map<Integer, Throwable> getExceptions() {
        return this.exceptions;
    }

    private static Message buildExceptionMessage(Map<Integer, Throwable> exceptions) {
        StringBuilder builder = new StringBuilder();
        for (Integer route : exceptions.keySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(route);
        }
        builder.insert(0, "Exception was found for route(s): ");
        return MessageFactory.createStaticMessage(builder.toString());
    }
}

