/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.security.SecurityContext;
import org.mule.api.transformer.DataType;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;
import org.mule.util.CaseInsensitiveHashMap;
import org.mule.util.UUID;

public final class DefaultMuleSession
implements MuleSession {
    private static final long serialVersionUID = 3380926585676521866L;
    private static Log logger = LogFactory.getLog(DefaultMuleSession.class);
    private boolean valid = true;
    private String id;
    private SecurityContext securityContext;
    private Map<String, TypedValue> properties;
    @Deprecated
    private FlowConstruct flowConstruct;

    public DefaultMuleSession() {
        this.id = UUID.getUUID();
        this.properties = Collections.synchronizedMap(new CaseInsensitiveHashMap());
    }

    public DefaultMuleSession(MuleSession session) {
        this.id = session.getId();
        this.securityContext = session.getSecurityContext();
        this.valid = session.isValid();
        this.properties = Collections.synchronizedMap(new CaseInsensitiveHashMap());
        for (String key : session.getPropertyNamesAsSet()) {
            this.properties.put(key, this.createTypedValue(session, key));
        }
    }

    private TypedValue createTypedValue(MuleSession session, String key) {
        return new TypedValue(session.getProperty(key), session.getPropertyDataType(key));
    }

    @Deprecated
    public DefaultMuleSession(MuleContext muleContext) {
        this();
    }

    @Deprecated
    public DefaultMuleSession(FlowConstruct flowConstruct, MuleContext muleContext) {
        this();
        this.flowConstruct = flowConstruct;
    }

    @Deprecated
    public DefaultMuleSession(MuleSession source, MuleContext muleContext) {
        this(source);
    }

    @Deprecated
    public DefaultMuleSession(MuleSession source, FlowConstruct flowConstruct) {
        this(source);
        this.flowConstruct = flowConstruct;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean value) {
        this.valid = value;
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        this.securityContext = context;
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public void setProperty(String key, Object value) {
        if (!(value instanceof Serializable)) {
            logger.warn((Object)CoreMessages.sessionPropertyNotSerializableWarning(key));
        }
        DataType<?> dataType = DataTypeFactory.createFromObject(value);
        this.properties.put(key, new TypedValue(value, dataType));
    }

    @Override
    public <T> T getProperty(Object key) {
        TypedValue typedValue = this.properties.get(key);
        return (T)(typedValue == null ? null : typedValue.getValue());
    }

    @Override
    public Object removeProperty(Object key) {
        return this.properties.remove(key);
    }

    @Override
    @Deprecated
    public Iterator<String> getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    @Override
    public Set<String> getPropertyNamesAsSet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public void merge(MuleSession updatedSession) {
        if (updatedSession == null) {
            return;
        }
        Iterator<Map.Entry<String, TypedValue>> propertyIterator = this.properties.entrySet().iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<String, TypedValue> entry = propertyIterator.next();
            if (!(entry.getValue().getValue() instanceof Serializable)) continue;
            propertyIterator.remove();
        }
        for (String updatedPropertyKey : updatedSession.getPropertyNamesAsSet()) {
            this.properties.put(updatedPropertyKey, this.createTypedValue(updatedSession, updatedPropertyKey));
        }
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : this.properties.keySet()) {
            TypedValue typedValue = this.properties.get(key);
            result.put(key, typedValue.getValue());
        }
        return result;
    }

    public Map<String, TypedValue> getExtendedProperties() {
        return this.properties;
    }

    void removeNonSerializableProperties() {
        Iterator<Map.Entry<String, TypedValue>> propertyIterator = this.properties.entrySet().iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry<String, TypedValue> entry = propertyIterator.next();
            if (entry.getValue().getValue() instanceof Serializable) continue;
            logger.warn((Object)CoreMessages.propertyNotSerializableWasDropped(entry.getKey()));
            propertyIterator.remove();
        }
    }

    @Override
    public void setProperty(String key, Serializable value) {
        this.setProperty(key, value, DataTypeFactory.createFromObject(value));
    }

    @Override
    public void setProperty(String key, Serializable value, DataType<?> dataType) {
        this.properties.put(key, new TypedValue(value, dataType));
    }

    @Override
    public <T> T getProperty(String key) {
        return this.getProperty((Object)key);
    }

    @Override
    public Object removeProperty(String key) {
        return this.removeProperty((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        DefaultMuleSession copy = new DefaultMuleSession(this);
        copy.removeNonSerializableProperties();
        Map<String, TypedValue> backupProperties = this.properties;
        try {
            this.properties = copy.properties;
            out.defaultWriteObject();
        }
        finally {
            this.properties = backupProperties;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public DataType<?> getPropertyDataType(String name) {
        TypedValue typedValue = this.properties.get(name);
        return typedValue == null ? null : typedValue.getDataType();
    }
}

