/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.session.AbstractSessionHandler;
import org.mule.session.DefaultMuleSession;

public class SerializeOnlySessionHandler
extends AbstractSessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        MuleSession session = null;
        byte[] serializedSession = (byte[])message.getInboundProperty("MULE_SESSION");
        if (serializedSession != null) {
            session = (MuleSession)this.deserialize(message, serializedSession);
        }
        return session;
    }

    @Override
    public void retrieveSessionInfoFromMessage(MuleMessage message, MuleSession session) throws MuleException {
        session = this.retrieveSessionInfoFromMessage(message);
    }

    @Override
    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        MuleContext muleContext = message.getMuleContext();
        byte[] serializedSession = muleContext.getObjectSerializer().serialize(this.removeNonSerializableProperties(session, muleContext));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding serialized Session header to message: " + serializedSession));
        }
        message.setOutboundProperty("MULE_SESSION", serializedSession);
    }

    protected MuleSession removeNonSerializableProperties(MuleSession session, MuleContext muleContext) {
        DefaultMuleSession copy = new DefaultMuleSession(session);
        copy.removeNonSerializableProperties();
        return copy;
    }

    @Override
    public String getSessionIDKey() {
        return "ID";
    }
}

