/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.util.Map;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;

public class MapToBean
extends AbstractTransformer
implements DiscoverableTransformer {
    public static final String CLASS_PROPERTY = "className";
    private int priorityWeighting = 1;

    public MapToBean() {
        this.registerSourceType(DataTypeFactory.create(Map.class));
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getReturnClass().equals(Object.class)) {
            throw new InitialisationException(CoreMessages.propertiesNotSet("returnClass"), (Initialisable)this);
        }
    }

    @Override
    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            Map props = (Map)src;
            String c = (String)props.remove(CLASS_PROPERTY);
            Class clazz = this.getReturnClass();
            if (c == null && clazz.equals(Object.class)) {
                throw new TransformerException(CoreMessages.transforemrMapBeanClassNotSet());
            }
            if (c != null) {
                clazz = ClassUtils.loadClass(c, this.getClass());
            }
            Object result = ClassUtils.instanciateClass(clazz, ClassUtils.NO_ARGS);
            BeanUtils.populate(result, props);
            return result;
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int weighting) {
        this.priorityWeighting = weighting;
    }
}

