/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.Serializable;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class SerializableToByteArray
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public SerializableToByteArray() {
        this.registerSourceType(DataTypeFactory.create(Serializable.class));
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    public boolean isAcceptMuleMessage() {
        return this.isSourceDataTypeSupported(DataTypeFactory.MULE_MESSAGE, true);
    }

    public void setAcceptMuleMessage(boolean value) {
        if (value) {
            this.registerSourceType(DataTypeFactory.MULE_MESSAGE);
        } else {
            this.unregisterSourceType(DataTypeFactory.MULE_MESSAGE);
        }
    }

    @Override
    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        try {
            return this.muleContext.getObjectSerializer().serialize(src);
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

