/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.types;

import java.nio.charset.Charset;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.commons.beanutils.MethodUtils;
import org.mule.api.transformer.DataType;
import org.mule.transformer.types.ImmutableDataType;
import org.mule.util.StringUtils;

public class SimpleDataType<T>
implements DataType<T>,
Cloneable {
    private static final String CHARSET_PARAM = "charset";
    protected final Class<?> type;
    protected String mimeType = "*/*";
    protected String encoding;

    public SimpleDataType(Class<?> type, String mimeType) {
        this.type = type;
        this.setMimeType(mimeType);
    }

    public SimpleDataType(Class type) {
        this.type = type;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            this.mimeType = "*/*";
        } else {
            try {
                MimeType mt = new MimeType(mimeType);
                this.mimeType = mt.getPrimaryType() + "/" + mt.getSubType();
                if (mt.getParameter(CHARSET_PARAM) != null) {
                    this.setEncoding(mt.getParameter(CHARSET_PARAM));
                }
            }
            catch (MimeTypeParseException e) {
                throw new IllegalArgumentException("MimeType cannot be parsed :" + mimeType);
            }
        }
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        if (!StringUtils.isEmpty((String)encoding)) {
            Charset.forName(encoding);
        }
        this.encoding = encoding;
    }

    @Override
    public boolean isCompatibleWith(DataType dataType) {
        if (dataType instanceof ImmutableDataType) {
            dataType = ((ImmutableDataType)dataType).getWrappedDataType();
        }
        if (this == dataType) {
            return true;
        }
        if (dataType == null) {
            return false;
        }
        SimpleDataType that = (SimpleDataType)dataType;
        if ((this.getMimeType() == null && that.getMimeType() != null || that.getMimeType() == null && this.getMimeType() != null) && !"*/*".equals(this.mimeType) && !"*/*".equals(that.mimeType)) {
            return false;
        }
        if (!(this.getMimeType() == null || this.getMimeType().equals(that.getMimeType()) || "*/*".equals(that.getMimeType()) || "*/*".equals(this.getMimeType()))) {
            return false;
        }
        return this.fromPrimitive(this.getType()).isAssignableFrom(this.fromPrimitive(that.getType()));
    }

    private Class<?> fromPrimitive(Class<?> type) {
        Class primitiveWrapper = MethodUtils.getPrimitiveWrapper(type);
        if (primitiveWrapper != null) {
            return primitiveWrapper;
        }
        return type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDataType that = (SimpleDataType)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if ((this.mimeType == null && that.mimeType != null || that.mimeType == null && this.mimeType != null) && !"*/*".equals(that.mimeType)) {
            return false;
        }
        return this.mimeType == null || this.mimeType.equals(that.mimeType) || "*/*".equals(that.mimeType);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SimpleDataType{type=" + (this.type == null ? null : this.type.getName()) + ", mimeType='" + this.mimeType + '\'' + ", encoding='" + this.encoding + '\'' + '}';
    }

    @Override
    public DataType cloneDataType() {
        try {
            return (DataType)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

