/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.journal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.util.journal.JournalEntry;
import org.mule.util.journal.JournalEntrySerializer;

class TransactionJournalFile<T, K extends JournalEntry<T>> {
    private static final int MINIMUM_ENTRIES_TO_CLEAR_FILE = 10000;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private final File journalFile;
    private final JournalEntrySerializer<T, K> journalEntrySerializer;
    private Multimap<T, K> entries = LinkedHashMultimap.create();
    private DataOutputStream logFileOutputStream;
    private int journalOperations = 0;

    public TransactionJournalFile(File journalFile, JournalEntrySerializer journalEntrySerializer) {
        this.journalFile = journalFile;
        this.journalEntrySerializer = journalEntrySerializer;
        if (journalFile.exists()) {
            this.loadAllEntries();
        }
        this.createLogOutputStream();
    }

    public synchronized void logOperation(K journalEntry) {
        this.entries.put(journalEntry.getTxId(), journalEntry);
        this.journalEntrySerializer.serialize(journalEntry, this.logFileOutputStream);
        ++this.journalOperations;
    }

    public synchronized void clearEntriesForTransaction(T txId) {
        Collection entries = this.entries.removeAll(txId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Evicted from tx log file " + entries.size() + " entries from txid " + txId));
        }
        if (this.entries.isEmpty() && this.journalOperations > 10000) {
            this.clear();
            this.journalOperations = 0;
        }
    }

    public synchronized void close() {
        block2: {
            try {
                this.logFileOutputStream.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)e.getMessage());
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<K> getLogEntries(T txId) {
        Collection entries = (Collection)this.entries.asMap().get(txId);
        if (entries == null) {
            return Collections.emptyList();
        }
        Collection collection = entries;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new ArrayList(entries));
        }
    }

    public synchronized Multimap<T, K> getAllLogEntries() {
        return this.entries;
    }

    public synchronized void clear() {
        this.close();
        this.entries.clear();
        FileUtils.deleteQuietly((File)this.journalFile);
        this.createLogOutputStream();
    }

    private void createLogOutputStream() {
        if (!this.journalFile.exists()) {
            try {
                this.journalFile.createNewFile();
            }
            catch (IOException e) {
                throw new MuleRuntimeException(e);
            }
        }
        try {
            this.logFileOutputStream = new DataOutputStream(new FileOutputStream(this.journalFile, true));
        }
        catch (FileNotFoundException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private void loadAllEntries() {
        if (!this.journalFile.exists()) {
            return;
        }
        FilterInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.journalFile)));
            boolean logEntryCreationFailed = false;
            while (!logEntryCreationFailed) {
                try {
                    K journalEntry = this.journalEntrySerializer.deserialize((DataInputStream)dataInputStream);
                    if (journalEntry != null) {
                        this.entries.put(journalEntry.getTxId(), journalEntry);
                        continue;
                    }
                    logEntryCreationFailed = true;
                }
                catch (EOFException e) {
                    this.logger.debug((Object)"Expected exception since there are no more log entries", (Throwable)e);
                    logEntryCreationFailed = true;
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Exception reading transaction content. This is normal if the mule server was shutdown due to a failure" + e.getMessage()));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)e);
                    }
                    logEntryCreationFailed = true;
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }
    }

    public int size() {
        return this.entries.size();
    }

    public boolean containsTx(T txId) {
        return this.entries.containsKey(txId);
    }
}

