/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.packager.resources.processor;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.api.packager.resources.content.ResourcesContent;
import org.mule.tools.api.packager.resources.processor.ResourcesContentProcessor;
import org.mule.tools.api.packager.sources.MuleContentGenerator;
import org.mule.tools.api.packager.structure.FolderNames;

public class DomainBundleProjectResourcesContentProcessor
implements ResourcesContentProcessor {
    private Path domainFolderPath;
    private Path applicationsFolderPath;

    public DomainBundleProjectResourcesContentProcessor(Path targetFolder) {
        this.domainFolderPath = targetFolder.resolve(FolderNames.DOMAIN.value());
        this.applicationsFolderPath = targetFolder.resolve(FolderNames.APPLICATIONS.value());
    }

    @Override
    public void process(ResourcesContent resourcesContent) throws IOException {
        for (Artifact artifact : resourcesContent.getResources()) {
            this.copyAsDomainOrApplication(artifact);
        }
    }

    protected void copyAsDomainOrApplication(Artifact artifact) throws IOException {
        Path originPath = Paths.get(artifact.getUri());
        String packagingType = artifact.getArtifactCoordinates().getClassifier();
        Path destinationPath = packagingType.equals(PackagingType.MULE_DOMAIN.toString()) ? this.domainFolderPath : this.applicationsFolderPath;
        MuleContentGenerator.copyFile(originPath, destinationPath, originPath.getFileName().toString());
    }
}

