/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.composer.ComposerDependency;
import org.owasp.dependencycheck.data.composer.ComposerException;
import org.owasp.dependencycheck.data.composer.ComposerLockParser;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ComposerLockAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposerLockAnalyzer.class);
    private static final String ANALYZER_NAME = "Composer.lock analyzer";
    private static final String COMPOSER_LOCK = "composer.lock";
    private static final FileFilter FILE_FILTER = FileFilterBuilder.newInstance().addFilenames("composer.lock").build();

    @Override
    protected FileFilter getFileFilter() {
        return FILE_FILTER;
    }

    @Override
    protected void initializeFileTypeAnalyzer() throws InitializationException {
        try {
            this.getSha1MessageDigest();
        }
        catch (IllegalStateException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unable to create SHA1 MessageDigest", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(dependency.getActualFile());
            ComposerLockParser clp = new ComposerLockParser(fis);
            LOGGER.info("Checking composer.lock file {}", (Object)dependency.getActualFilePath());
            clp.process();
            for (ComposerDependency dep : clp.getDependencies()) {
                Dependency d = new Dependency(dependency.getActualFile());
                d.setDisplayFileName(String.format("%s:%s/%s", dependency.getDisplayFileName(), dep.getGroup(), dep.getProject()));
                String filePath = String.format("%s:%s/%s", dependency.getFilePath(), dep.getGroup(), dep.getProject());
                MessageDigest sha1 = this.getSha1MessageDigest();
                d.setFilePath(filePath);
                d.setSha1sum(Checksum.getHex((byte[])sha1.digest(filePath.getBytes(Charset.defaultCharset()))));
                d.getVendorEvidence().addEvidence(COMPOSER_LOCK, "vendor", dep.getGroup(), Confidence.HIGHEST);
                d.getProductEvidence().addEvidence(COMPOSER_LOCK, "product", dep.getProject(), Confidence.HIGHEST);
                d.getVersionEvidence().addEvidence(COMPOSER_LOCK, "version", dep.getVersion(), Confidence.HIGHEST);
                LOGGER.info("Adding dependency {}", (Object)d);
                engine.getDependencies().add(d);
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.warn("Error opening dependency {}", (Object)dependency.getActualFilePath());
        }
        catch (ComposerException ce) {
            LOGGER.warn("Error parsing composer.json {}", (Object)dependency.getActualFilePath(), (Object)ce);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    LOGGER.debug("Unable to close file", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.composer.lock.enabled";
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    private MessageDigest getSha1MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage());
            throw new IllegalStateException("Failed to obtain the SHA1 message digest.", e);
        }
    }
}

