/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.owasp.dependencycheck.data.update.BaseUpdater;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.cpe.CPEHandler;
import org.owasp.dependencycheck.data.update.cpe.Cpe;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ExtractionUtil;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class CpeUpdater
extends BaseUpdater
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CpeUpdater.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws UpdateException {
        try {
            this.openDataStores();
            if (this.updateNeeded()) {
                LOGGER.info("Updating the Common Platform Enumeration (CPE)");
                File xml = this.downloadCpe();
                List<Cpe> cpes = this.processXML(xml);
                this.getCveDB().deleteUnusedCpe();
                for (Cpe cpe : cpes) {
                    this.getCveDB().addCpe(cpe.getValue(), cpe.getVendor(), cpe.getProduct());
                }
                long now = System.currentTimeMillis();
                this.getProperties().save("LAST_CPE_UPDATE", Long.toString(now));
                LOGGER.info("CPE update complete");
            }
        }
        finally {
            this.closeDataStores();
        }
    }

    private File downloadCpe() throws UpdateException {
        File xml;
        try {
            URL url = new URL(Settings.getString((String)"cpe.url"));
            xml = File.createTempFile("cpe", ".xml", Settings.getTempDirectory());
            Downloader.fetchFile((URL)url, (File)xml);
            if (url.toExternalForm().endsWith(".xml.gz")) {
                ExtractionUtil.extractGzip(xml);
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException("Invalid CPE URL", ex);
        }
        catch (DownloadFailedException ex) {
            throw new UpdateException("Unable to download CPE XML file", ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to create temporary file to download CPE", ex);
        }
        return xml;
    }

    private List<Cpe> processXML(File xml) throws UpdateException {
        try {
            SAXParser saxParser = XmlUtils.buildSecureSaxParser();
            CPEHandler handler = new CPEHandler();
            saxParser.parse(xml, (DefaultHandler)handler);
            return handler.getData();
        }
        catch (ParserConfigurationException ex) {
            throw new UpdateException("Unable to parse CPE XML file due to SAX Parser Issue", ex);
        }
        catch (SAXException ex) {
            throw new UpdateException("Unable to parse CPE XML file due to SAX Parser Exception", ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to parse CPE XML file due to IO Failure", ex);
        }
    }

    private boolean updateNeeded() {
        long now = System.currentTimeMillis();
        int days = Settings.getInt((String)"cpe.validfordays", (int)30);
        long timestamp = 0L;
        String ts = this.getProperties().getProperty("LAST_CPE_UPDATE");
        if (ts != null && ts.matches("^[0-9]+$")) {
            timestamp = Long.parseLong(ts);
        }
        return !DateUtil.withinDateRange(timestamp, now, days);
    }
}

