/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class NvdCve12Handler
extends DefaultHandler {
    private static final String CURRENT_SCHEMA_VERSION = "1.2";
    private String vulnerability;
    private List<VulnerableSoftware> software;
    private String vendor;
    private String product;
    private boolean skip = false;
    private boolean hasPreviousVersion = false;
    private final Element current = new Element();
    private Map<String, List<VulnerableSoftware>> vulnerabilities;

    public Map<String, List<VulnerableSoftware>> getVulnerabilities() {
        return this.vulnerabilities;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.current.setNode(qName);
        if (this.current.isEntryNode()) {
            this.vendor = null;
            this.product = null;
            this.hasPreviousVersion = false;
            String reject = attributes.getValue("reject");
            this.skip = "1".equals(reject);
            if (!this.skip) {
                this.vulnerability = attributes.getValue("name");
                this.software = new ArrayList<VulnerableSoftware>();
            } else {
                this.vulnerability = null;
                this.software = null;
            }
        } else if (!this.skip && this.current.isProdNode()) {
            this.vendor = attributes.getValue("vendor");
            this.product = attributes.getValue("name");
        } else if (!this.skip && this.current.isVersNode()) {
            String prev = attributes.getValue("prev");
            if (prev != null && "1".equals(prev)) {
                this.hasPreviousVersion = true;
                String edition = attributes.getValue("edition");
                String num = attributes.getValue("num");
                int cpeLen = 8 + this.vendor.length() + this.product.length() + (null != num ? 1 + num.length() : 0) + (null != edition ? 1 + edition.length() : 0);
                StringBuilder cpe = new StringBuilder(cpeLen);
                cpe.append("cpe:/a:").append(this.vendor).append(':').append(this.product);
                if (num != null) {
                    cpe.append(':').append(num);
                }
                if (edition != null) {
                    cpe.append(':').append(edition);
                }
                VulnerableSoftware vs = new VulnerableSoftware();
                vs.setCpe(cpe.toString());
                vs.setPreviousVersion(prev);
                this.software.add(vs);
            }
        } else if (this.current.isNVDNode()) {
            String nvdVer = attributes.getValue("nvd_xml_version");
            if (!CURRENT_SCHEMA_VERSION.equals(nvdVer)) {
                throw new SAXNotSupportedException("Schema version " + nvdVer + " is not supported");
            }
            this.vulnerabilities = new HashMap<String, List<VulnerableSoftware>>();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.current.setNode(qName);
        if (this.current.isEntryNode()) {
            if (!this.skip && this.hasPreviousVersion) {
                this.vulnerabilities.put(this.vulnerability, this.software);
            }
            this.vulnerability = null;
            this.software = null;
        }
    }

    protected static class Element {
        public static final String NVD = "nvd";
        public static final String ENTRY = "entry";
        public static final String VULN_SOFTWARE = "vuln_soft";
        public static final String PROD = "prod";
        public static final String VERS = "vers";
        private String node;

        protected Element() {
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public boolean isNVDNode() {
            return NVD.equals(this.node);
        }

        public boolean isEntryNode() {
            return ENTRY.equals(this.node);
        }

        public boolean isVulnSoftwareNode() {
            return VULN_SOFTWARE.equals(this.node);
        }

        public boolean isProdNode() {
            return PROD.equals(this.node);
        }

        public boolean isVersNode() {
            return VERS.equals(this.node);
        }
    }
}

