/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class NvdCve20Handler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdCve20Handler.class);
    private static final String CURRENT_SCHEMA_VERSION = "2.0";
    private final Element current = new Element();
    private StringBuilder nodeText;
    private Vulnerability vulnerability;
    private Reference reference;
    private boolean hasApplicationCpe = false;
    private int totalNumberOfEntries;
    private int totalNumberOfApplicationEntries;
    private CveDB cveDB;
    private Map<String, List<VulnerableSoftware>> prevVersionVulnMap;

    public int getTotalNumberOfEntries() {
        return this.totalNumberOfEntries;
    }

    public int getTotalNumberOfApplicationEntries() {
        return this.totalNumberOfApplicationEntries;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.current.setNode(qName);
        if (this.current.isEntryNode()) {
            this.hasApplicationCpe = false;
            this.vulnerability = new Vulnerability();
            this.vulnerability.setName(attributes.getValue("id"));
        } else if (this.current.isVulnProductNode()) {
            this.nodeText = new StringBuilder(100);
        } else if (this.current.isVulnReferencesNode()) {
            String lang = attributes.getValue("xml:lang");
            this.reference = "en".equals(lang) ? new Reference() : null;
        } else if (this.reference != null && this.current.isVulnReferenceNode()) {
            this.reference.setUrl(attributes.getValue("href"));
            this.nodeText = new StringBuilder(130);
        } else if (this.reference != null && this.current.isVulnSourceNode()) {
            this.nodeText = new StringBuilder(30);
        } else if (this.current.isVulnSummaryNode()) {
            this.nodeText = new StringBuilder(500);
        } else if (this.current.isNVDNode()) {
            String nvdVer = attributes.getValue("nvd_xml_version");
            if (!CURRENT_SCHEMA_VERSION.equals(nvdVer)) {
                throw new SAXNotSupportedException("Schema version " + nvdVer + " is not supported");
            }
        } else if (this.current.isVulnCWENode()) {
            this.vulnerability.setCwe(attributes.getValue("id"));
        } else if (this.current.isCVSSScoreNode()) {
            this.nodeText = new StringBuilder(5);
        } else if (this.current.isCVSSAccessVectorNode()) {
            this.nodeText = new StringBuilder(20);
        } else if (this.current.isCVSSAccessComplexityNode()) {
            this.nodeText = new StringBuilder(20);
        } else if (this.current.isCVSSAuthenticationNode()) {
            this.nodeText = new StringBuilder(20);
        } else if (this.current.isCVSSAvailabilityImpactNode()) {
            this.nodeText = new StringBuilder(20);
        } else if (this.current.isCVSSConfidentialityImpactNode()) {
            this.nodeText = new StringBuilder(20);
        } else if (this.current.isCVSSIntegrityImpactNode()) {
            this.nodeText = new StringBuilder(20);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.nodeText != null) {
            this.nodeText.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.current.setNode(qName);
        if (this.current.isEntryNode()) {
            ++this.totalNumberOfEntries;
            if (this.hasApplicationCpe) {
                ++this.totalNumberOfApplicationEntries;
                try {
                    this.saveEntry(this.vulnerability);
                }
                catch (DatabaseException ex) {
                    throw new SAXException(ex);
                }
                catch (CorruptIndexException ex) {
                    throw new SAXException((Exception)((Object)ex));
                }
                catch (IOException ex) {
                    throw new SAXException(ex);
                }
            }
            this.vulnerability = null;
        } else if (this.current.isCVSSScoreNode()) {
            try {
                float score = Float.parseFloat(this.nodeText.toString());
                this.vulnerability.setCvssScore(score);
            }
            catch (NumberFormatException ex) {
                LOGGER.error("Error parsing CVSS Score.");
                LOGGER.debug("", (Throwable)ex);
            }
            this.nodeText = null;
        } else if (this.current.isCVSSAccessVectorNode()) {
            this.vulnerability.setCvssAccessVector(this.nodeText.toString());
            this.nodeText = null;
        } else if (this.current.isCVSSAccessComplexityNode()) {
            this.vulnerability.setCvssAccessComplexity(this.nodeText.toString());
            this.nodeText = null;
        } else if (this.current.isCVSSAuthenticationNode()) {
            this.vulnerability.setCvssAuthentication(this.nodeText.toString());
            this.nodeText = null;
        } else if (this.current.isCVSSAvailabilityImpactNode()) {
            this.vulnerability.setCvssAvailabilityImpact(this.nodeText.toString());
            this.nodeText = null;
        } else if (this.current.isCVSSConfidentialityImpactNode()) {
            this.vulnerability.setCvssConfidentialityImpact(this.nodeText.toString());
            this.nodeText = null;
        } else if (this.current.isCVSSIntegrityImpactNode()) {
            this.vulnerability.setCvssIntegrityImpact(this.nodeText.toString());
            this.nodeText = null;
        } else if (this.current.isVulnProductNode()) {
            String cpe = this.nodeText.toString();
            if (cpe.startsWith("cpe:/a:")) {
                this.hasApplicationCpe = true;
                this.vulnerability.addVulnerableSoftware(cpe);
            }
            this.nodeText = null;
        } else if (this.reference != null && this.current.isVulnReferencesNode()) {
            this.vulnerability.addReference(this.reference);
            this.reference = null;
        } else if (this.reference != null && this.current.isVulnReferenceNode()) {
            this.reference.setName(this.nodeText.toString());
            this.nodeText = null;
        } else if (this.reference != null && this.current.isVulnSourceNode()) {
            this.reference.setSource(this.nodeText.toString());
            this.nodeText = null;
        } else if (this.current.isVulnSummaryNode()) {
            this.vulnerability.setDescription(this.nodeText.toString());
            if (this.nodeText.indexOf("** REJECT **") >= 0) {
                this.hasApplicationCpe = true;
            }
            this.nodeText = null;
        }
    }

    public void setCveDB(CveDB db) {
        this.cveDB = db;
    }

    public void setPrevVersionVulnMap(Map<String, List<VulnerableSoftware>> map) {
        this.prevVersionVulnMap = map;
    }

    private void saveEntry(Vulnerability vuln) throws DatabaseException, CorruptIndexException, IOException {
        String cveName = vuln.getName();
        if (this.prevVersionVulnMap != null && this.prevVersionVulnMap.containsKey(cveName)) {
            List<VulnerableSoftware> vulnSoftware = this.prevVersionVulnMap.get(cveName);
            for (VulnerableSoftware vs : vulnSoftware) {
                vuln.updateVulnerableSoftware(vs);
            }
        }
        if (this.cveDB != null) {
            this.cveDB.updateVulnerability(vuln);
        }
    }

    protected static class Element {
        public static final String NVD = "nvd";
        public static final String ENTRY = "entry";
        public static final String VULN_PRODUCT = "vuln:product";
        public static final String VULN_REFERENCES = "vuln:references";
        public static final String VULN_SOURCE = "vuln:source";
        public static final String VULN_REFERENCE = "vuln:reference";
        public static final String VULN_SUMMARY = "vuln:summary";
        public static final String VULN_CWE = "vuln:cwe";
        public static final String CVSS_SCORE = "cvss:score";
        public static final String CVSS_ACCESS_VECTOR = "cvss:access-vector";
        public static final String CVSS_ACCESS_COMPLEXITY = "cvss:access-complexity";
        public static final String CVSS_AUTHENTICATION = "cvss:authentication";
        public static final String CVSS_CONFIDENTIALITY_IMPACT = "cvss:confidentiality-impact";
        public static final String CVSS_INTEGRITY_IMPACT = "cvss:integrity-impact";
        public static final String CVSS_AVAILABILITY_IMPACT = "cvss:availability-impact";
        private String node;

        protected Element() {
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public boolean isNVDNode() {
            return NVD.equals(this.node);
        }

        public boolean isEntryNode() {
            return ENTRY.equals(this.node);
        }

        public boolean isVulnProductNode() {
            return VULN_PRODUCT.equals(this.node);
        }

        public boolean isVulnReferencesNode() {
            return VULN_REFERENCES.equals(this.node);
        }

        public boolean isVulnReferenceNode() {
            return VULN_REFERENCE.equals(this.node);
        }

        public boolean isVulnSourceNode() {
            return VULN_SOURCE.equals(this.node);
        }

        public boolean isVulnSummaryNode() {
            return VULN_SUMMARY.equals(this.node);
        }

        public boolean isVulnCWENode() {
            return VULN_CWE.equals(this.node);
        }

        public boolean isCVSSScoreNode() {
            return CVSS_SCORE.equals(this.node);
        }

        public boolean isCVSSAccessVectorNode() {
            return CVSS_ACCESS_VECTOR.equals(this.node);
        }

        public boolean isCVSSAccessComplexityNode() {
            return CVSS_ACCESS_COMPLEXITY.equals(this.node);
        }

        public boolean isCVSSAuthenticationNode() {
            return CVSS_AUTHENTICATION.equals(this.node);
        }

        public boolean isCVSSConfidentialityImpactNode() {
            return CVSS_CONFIDENTIALITY_IMPACT.equals(this.node);
        }

        public boolean isCVSSIntegrityImpactNode() {
            return CVSS_INTEGRITY_IMPACT.equals(this.node);
        }

        public boolean isCVSSAvailabilityImpactNode() {
            return CVSS_AVAILABILITY_IMPACT.equals(this.node);
        }
    }
}

