/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerabilityComparator;
import org.owasp.dependencycheck.utils.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dependency
implements Serializable,
Comparable<Dependency> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Dependency.class);
    private static final int MAGIC_HASH_INIT_VALUE = 3;
    private static final int MAGIC_HASH_MULTIPLIER = 47;
    private String actualFilePath;
    private String filePath;
    private String fileName;
    private String packagePath;
    private String md5sum;
    private String sha1sum;
    private Set<Identifier> identifiers;
    private final EvidenceCollection vendorEvidence;
    private final EvidenceCollection productEvidence;
    private final EvidenceCollection versionEvidence;
    private String displayName = null;
    private Set<Identifier> suppressedIdentifiers;
    private SortedSet<Vulnerability> suppressedVulnerabilities;
    private String description;
    private String license;
    private SortedSet<Vulnerability> vulnerabilities;
    private Set<Dependency> relatedDependencies = new TreeSet<Dependency>();
    private Set<String> projectReferences = new HashSet<String>();
    private List<String> availableVersions = new ArrayList<String>();

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public Dependency() {
        this.vendorEvidence = new EvidenceCollection();
        this.productEvidence = new EvidenceCollection();
        this.versionEvidence = new EvidenceCollection();
        this.identifiers = new TreeSet<Identifier>();
        this.vulnerabilities = new TreeSet<Vulnerability>(new VulnerabilityComparator());
        this.suppressedIdentifiers = new TreeSet<Identifier>();
        this.suppressedVulnerabilities = new TreeSet<Vulnerability>(new VulnerabilityComparator());
    }

    public Dependency(File file) {
        this();
        this.filePath = this.actualFilePath = file.getAbsolutePath();
        this.fileName = file.getName();
        this.packagePath = this.filePath;
        this.determineHashes(file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameForJavaScript() {
        return this.fileName.replace("\\", "\\\\");
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setActualFilePath(String actualFilePath) {
        this.actualFilePath = actualFilePath;
        if (this.sha1sum == null) {
            File file = new File(this.actualFilePath);
            this.determineHashes(file);
        }
    }

    public String getActualFilePath() {
        return this.actualFilePath;
    }

    public File getActualFile() {
        return new File(this.actualFilePath);
    }

    public void setFilePath(String filePath) {
        if (this.packagePath == null || this.packagePath.equals(this.filePath)) {
            this.packagePath = filePath;
        }
        this.filePath = filePath;
    }

    public void setDisplayFileName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayFileName() {
        if (this.displayName == null) {
            return this.fileName;
        }
        return this.displayName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public void setMd5sum(String md5sum) {
        this.md5sum = md5sum;
    }

    public String getSha1sum() {
        return this.sha1sum;
    }

    public void setSha1sum(String sha1sum) {
        this.sha1sum = sha1sum;
    }

    public Set<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(Set<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public void addIdentifier(String type, String value, String url) {
        Identifier i = new Identifier(type, value, url);
        this.identifiers.add(i);
    }

    public void addIdentifier(String type, String value, String url, Confidence confidence) {
        Identifier i = new Identifier(type, value, url);
        i.setConfidence(confidence);
        this.identifiers.add(i);
    }

    public void addAsEvidence(String source, MavenArtifact mavenArtifact, Confidence confidence) {
        if (mavenArtifact.getGroupId() != null && !mavenArtifact.getGroupId().isEmpty()) {
            this.getVendorEvidence().addEvidence(source, "groupid", mavenArtifact.getGroupId(), confidence);
        }
        if (mavenArtifact.getArtifactId() != null && !mavenArtifact.getArtifactId().isEmpty()) {
            this.getProductEvidence().addEvidence(source, "artifactid", mavenArtifact.getArtifactId(), confidence);
        }
        if (mavenArtifact.getVersion() != null && !mavenArtifact.getVersion().isEmpty()) {
            this.getVersionEvidence().addEvidence(source, "version", mavenArtifact.getVersion(), confidence);
        }
        if (mavenArtifact.getArtifactUrl() != null && !mavenArtifact.getArtifactUrl().isEmpty()) {
            boolean found = false;
            for (Identifier i : this.getIdentifiers()) {
                if (!"maven".equals(i.getType()) || !i.getValue().equals(mavenArtifact.toString())) continue;
                found = true;
                i.setConfidence(Confidence.HIGHEST);
                String url = "http://search.maven.org/#search|ga|1|1%3A%22" + this.getSha1sum() + "%22";
                i.setUrl(url);
                LOGGER.debug("Already found identifier {}. Confidence set to highest", (Object)i.getValue());
                break;
            }
            if (!found) {
                LOGGER.debug("Adding new maven identifier {}", (Object)mavenArtifact);
                this.addIdentifier("maven", mavenArtifact.toString(), mavenArtifact.getArtifactUrl(), Confidence.HIGHEST);
            }
        }
    }

    public void addIdentifier(Identifier identifier) {
        this.identifiers.add(identifier);
    }

    public Set<Identifier> getSuppressedIdentifiers() {
        return this.suppressedIdentifiers;
    }

    public void setSuppressedIdentifiers(Set<Identifier> suppressedIdentifiers) {
        this.suppressedIdentifiers = suppressedIdentifiers;
    }

    public void addSuppressedIdentifier(Identifier identifier) {
        this.suppressedIdentifiers.add(identifier);
    }

    public SortedSet<Vulnerability> getSuppressedVulnerabilities() {
        return this.suppressedVulnerabilities;
    }

    public void setSuppressedVulnerabilities(SortedSet<Vulnerability> suppressedVulnerabilities) {
        this.suppressedVulnerabilities = suppressedVulnerabilities;
    }

    public void addSuppressedVulnerability(Vulnerability vulnerability) {
        this.suppressedVulnerabilities.add(vulnerability);
    }

    public EvidenceCollection getEvidence() {
        return EvidenceCollection.merge(this.productEvidence, this.vendorEvidence, this.versionEvidence);
    }

    public Set<Evidence> getEvidenceForDisplay() {
        return EvidenceCollection.mergeForDisplay(this.productEvidence, this.vendorEvidence, this.versionEvidence);
    }

    public EvidenceCollection getEvidenceUsed() {
        return EvidenceCollection.mergeUsed(this.productEvidence, this.vendorEvidence, this.versionEvidence);
    }

    public EvidenceCollection getVendorEvidence() {
        return this.vendorEvidence;
    }

    public EvidenceCollection getProductEvidence() {
        return this.productEvidence;
    }

    public EvidenceCollection getVersionEvidence() {
        return this.versionEvidence;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public SortedSet<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public void setVulnerabilities(SortedSet<Vulnerability> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    private void determineHashes(File file) {
        String md5 = null;
        String sha1 = null;
        try {
            md5 = Checksum.getMD5Checksum((File)file);
            sha1 = Checksum.getSHA1Checksum((File)file);
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to read '{}' to determine hashes.", (Object)file.getName());
            LOGGER.debug("", (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn("Unable to use MD5 of SHA1 checksums.");
            LOGGER.debug("", (Throwable)ex);
        }
        this.setMd5sum(md5);
        this.setSha1sum(sha1);
    }

    public void addVulnerability(Vulnerability vulnerability) {
        this.vulnerabilities.add(vulnerability);
    }

    public Set<Dependency> getRelatedDependencies() {
        return this.relatedDependencies;
    }

    public Set<String> getProjectReferences() {
        return this.projectReferences;
    }

    public void setProjectReferences(Set<String> projectReferences) {
        this.projectReferences = projectReferences;
    }

    public void addProjectReference(String projectReference) {
        this.projectReferences.add(projectReference);
    }

    public void addAllProjectReferences(Set<String> projectReferences) {
        this.projectReferences.addAll(projectReferences);
    }

    public void setRelatedDependencies(Set<Dependency> relatedDependencies) {
        this.relatedDependencies = relatedDependencies;
    }

    public void addRelatedDependency(Dependency dependency) {
        if (this == dependency) {
            LOGGER.warn("Attempted to add a circular reference - please post the log file to issue #172 here https://github.com/jeremylong/DependencyCheck/issues/172");
            LOGGER.debug("this: {}", (Object)this);
            LOGGER.debug("dependency: {}", (Object)dependency);
        } else if (!this.relatedDependencies.add(dependency)) {
            LOGGER.debug("Failed to add dependency, likely due to referencing the same file as another dependency in the set.");
            LOGGER.debug("this: {}", (Object)this);
            LOGGER.debug("dependency: {}", (Object)dependency);
        }
    }

    public List<String> getAvailableVersions() {
        return this.availableVersions;
    }

    public void setAvailableVersions(List<String> availableVersions) {
        this.availableVersions = availableVersions;
    }

    public void addAvailableVersion(String version) {
        this.availableVersions.add(version);
    }

    @Override
    public int compareTo(Dependency o) {
        return this.getFilePath().compareToIgnoreCase(o.getFilePath());
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.actualFilePath, (Object)other.actualFilePath).append((Object)this.filePath, (Object)other.filePath).append((Object)this.fileName, (Object)other.fileName).append((Object)this.packagePath, (Object)other.packagePath).append((Object)this.md5sum, (Object)other.md5sum).append((Object)this.sha1sum, (Object)other.sha1sum).append(this.identifiers, other.identifiers).append((Object)this.vendorEvidence, (Object)other.vendorEvidence).append((Object)this.productEvidence, (Object)other.productEvidence).append((Object)this.versionEvidence, (Object)other.versionEvidence).append((Object)this.description, (Object)other.description).append((Object)this.license, (Object)other.license).append(this.vulnerabilities, other.vulnerabilities).append(this.projectReferences, other.projectReferences).append(this.availableVersions, other.availableVersions).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 47).append((Object)this.actualFilePath).append((Object)this.filePath).append((Object)this.fileName).append((Object)this.md5sum).append((Object)this.sha1sum).append(this.identifiers).append((Object)this.vendorEvidence).append((Object)this.productEvidence).append((Object)this.versionEvidence).append((Object)this.description).append((Object)this.license).append(this.vulnerabilities).append(this.projectReferences).append(this.availableVersions).toHashCode();
    }

    public String toString() {
        return "Dependency{ fileName='" + this.fileName + "', actualFilePath='" + this.actualFilePath + "', filePath='" + this.filePath + "', packagePath='" + this.packagePath + "'}";
    }
}

