/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.ArchiveExtractionException;
import org.owasp.dependencycheck.utils.ExtractionException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtractionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractionUtil.class);

    private ExtractionUtil() {
    }

    public static void extractFiles(File archive, File extractTo) throws ExtractionException {
        ExtractionUtil.extractFiles(archive, extractTo, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extractFiles(File archive, File extractTo, Engine engine) throws ExtractionException {
        if (archive == null) return;
        if (extractTo == null) {
            return;
        }
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            fis = new FileInputStream(archive);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException("Archive file was not found.", (Throwable)ex);
        }
        zis = new ZipInputStream(new BufferedInputStream(fis));
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File d = new File(extractTo, entry.getName());
                    if (d.exists() || d.mkdirs()) continue;
                    String msg = String.format("Unable to create '%s'.", d.getAbsolutePath());
                    throw new ExtractionException(msg);
                }
                File file = new File(extractTo, entry.getName());
                if (engine != null && !engine.accept(file)) continue;
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                    IOUtils.copy((InputStream)zis, (OutputStream)fos);
                }
                catch (FileNotFoundException ex) {
                    try {
                        LOGGER.debug("", (Throwable)ex);
                        String msg = String.format("Unable to find file '%s'.", file.getName());
                        throw new ExtractionException(msg, (Throwable)ex);
                        catch (IOException ex2) {
                            LOGGER.debug("", (Throwable)ex2);
                            msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                            throw new ExtractionException(msg, (Throwable)ex2);
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(fos);
                        throw throwable;
                    }
                }
                FileUtils.close((Closeable)fos);
            }
            return;
        }
        catch (IOException ex) {
            String msg = String.format("Exception reading archive '%s'.", archive.getName());
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException(msg, (Throwable)ex);
        }
        finally {
            FileUtils.close((Closeable)zis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFilesUsingFilter(File archive, File destination, FilenameFilter filter) throws ExtractionException {
        if (archive == null || destination == null) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(archive);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException("Archive file was not found.", (Throwable)ex);
        }
        try {
            ExtractionUtil.extractArchive((ArchiveInputStream)new ZipArchiveInputStream((InputStream)new BufferedInputStream(fis)), destination, filter);
        }
        catch (ArchiveExtractionException ex) {
            LOGGER.warn("Exception extracting archive '{}'.", (Object)archive.getName());
            LOGGER.debug("", (Throwable)ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    private static void extractArchive(ArchiveInputStream input, File destination, FilenameFilter filter) throws ArchiveExtractionException {
        try {
            ArchiveEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File dir = new File(destination, entry.getName());
                    if (dir.exists() || dir.mkdirs()) continue;
                    String msg = String.format("Unable to create directory '%s'.", dir.getAbsolutePath());
                    throw new AnalysisException(msg);
                }
                ExtractionUtil.extractFile(input, destination, filter, entry);
            }
        }
        catch (IOException ex) {
            throw new ArchiveExtractionException(ex);
        }
        catch (Throwable ex) {
            throw new ArchiveExtractionException(ex);
        }
        finally {
            FileUtils.close((Closeable)input);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractFile(ArchiveInputStream input, File destination, FilenameFilter filter, ArchiveEntry entry) throws ExtractionException {
        File file = new File(destination, entry.getName());
        if (!filter.accept(file.getParentFile(), file.getName())) return;
        LOGGER.debug("Extracting '{}'", (Object)file.getPath());
        FileOutputStream fos = null;
        try {
            ExtractionUtil.createParentFile(file);
            fos = new FileOutputStream(file);
            IOUtils.copy((InputStream)input, (OutputStream)fos);
        }
        catch (FileNotFoundException ex) {
            try {
                LOGGER.debug("", (Throwable)ex);
                String msg = String.format("Unable to find file '%s'.", file.getName());
                throw new ExtractionException(msg, (Throwable)ex);
                catch (IOException ex2) {
                    LOGGER.debug("", (Throwable)ex2);
                    msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                    throw new ExtractionException(msg, (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(fos);
                throw throwable;
            }
        }
        FileUtils.close((Closeable)fos);
    }

    private static void createParentFile(File file) throws ExtractionException {
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            String msg = String.format("Unable to build directory '%s'.", parent.getAbsolutePath());
            throw new ExtractionException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractGzip(File file) throws FileNotFoundException, IOException {
        String originalPath = file.getPath();
        File gzip = new File(originalPath + ".gz");
        if (gzip.isFile() && !gzip.delete()) {
            LOGGER.debug("Failed to delete initial temporary file when extracting 'gz' {}", (Object)gzip.toString());
            gzip.deleteOnExit();
        }
        if (!file.renameTo(gzip)) {
            throw new IOException("Unable to rename '" + file.getPath() + "'");
        }
        File newfile = new File(originalPath);
        byte[] buffer = new byte[4096];
        GZIPInputStream cin = null;
        FileOutputStream out = null;
        try {
            int len;
            cin = new GZIPInputStream(new FileInputStream(gzip));
            out = new FileOutputStream(newfile);
            while ((len = cin.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (cin != null) {
                try {
                    cin.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("ignore", (Throwable)ex);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("ignore", (Throwable)ex);
                }
            }
            if (gzip.isFile() && !org.apache.commons.io.FileUtils.deleteQuietly((File)gzip)) {
                LOGGER.debug("Failed to delete temporary file when extracting 'gz' {}", (Object)gzip.toString());
                gzip.deleteOnExit();
            }
        }
    }
}

