/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EngineVersionCheck
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineVersionCheck.class);
    public static final String ENGINE_VERSION_CHECKED_ON = "VersionCheckOn";
    public static final String CURRENT_ENGINE_RELEASE = "CurrentEngineRelease";
    private String updateToVersion;
    private Settings settings;

    protected EngineVersionCheck(Settings settings) {
        this.settings = settings;
    }

    public EngineVersionCheck() {
    }

    protected String getUpdateToVersion() {
        return this.updateToVersion;
    }

    protected void setUpdateToVersion(String version) {
        this.updateToVersion = version;
    }

    @Override
    public boolean update(Engine engine) throws UpdateException {
        this.settings = engine.getSettings();
        try {
            CveDB db = engine.getDatabase();
            boolean autoupdate = this.settings.getBoolean("odc.autoupdate", true);
            boolean enabled = this.settings.getBoolean("updater.versioncheck.enabled", true);
            String datafeed = this.settings.getString("nvd.api.datafeed.url");
            if (enabled && autoupdate && datafeed != null) {
                LOGGER.debug("Begin Engine Version Check");
                DatabaseProperties properties = db.getDatabaseProperties();
                long lastChecked = DateUtil.getEpochValueInSeconds(properties.getProperty(ENGINE_VERSION_CHECKED_ON, "0"));
                long now = System.currentTimeMillis() / 1000L;
                this.updateToVersion = properties.getProperty(CURRENT_ENGINE_RELEASE, "");
                String currentVersion = this.settings.getString("odc.application.version", "0.0.0");
                LOGGER.debug("Last checked: {}", (Object)lastChecked);
                LOGGER.debug("Now: {}", (Object)now);
                LOGGER.debug("Current version: {}", (Object)currentVersion);
                boolean updateNeeded = this.shouldUpdate(lastChecked, now, properties, currentVersion);
                if (updateNeeded) {
                    LOGGER.warn("A new version of dependency-check is available. Consider updating to version {}.", (Object)this.updateToVersion);
                }
            }
        }
        catch (DatabaseException ex) {
            LOGGER.debug("Database Exception opening databases to retrieve properties", (Throwable)ex);
            throw new UpdateException("Error occurred updating database properties.");
        }
        return false;
    }

    protected boolean shouldUpdate(long lastChecked, long now, DatabaseProperties properties, String currentVersion) throws UpdateException {
        int checkRange = 30;
        if (!DateUtil.withinDateRange(lastChecked, now, 30)) {
            LOGGER.debug("Checking web for new version.");
            String publishedData = this.getCurrentReleaseVersion();
            if (publishedData != null) {
                String currentRelease;
                DependencyVersion v;
                String[] parts = publishedData.split("\n");
                if (parts.length > 1) {
                    String message = String.join((CharSequence)"\n", Arrays.copyOfRange(parts, 1, parts.length)).trim();
                    LOGGER.warn("\n\n*********************************************************\n" + message + "\n*********************************************************\n");
                }
                if ((v = new DependencyVersion(currentRelease = parts[0].trim())).getVersionParts() != null && v.getVersionParts().size() >= 3) {
                    this.updateToVersion = v.toString();
                    if (!currentRelease.equals(this.updateToVersion)) {
                        properties.save(CURRENT_ENGINE_RELEASE, this.updateToVersion);
                    }
                    properties.save(ENGINE_VERSION_CHECKED_ON, Long.toString(now));
                }
            }
            LOGGER.debug("Current Release: {}", (Object)this.updateToVersion);
        }
        if (this.updateToVersion == null) {
            LOGGER.debug("Unable to obtain current release");
            return false;
        }
        DependencyVersion running = new DependencyVersion(currentVersion);
        DependencyVersion released = new DependencyVersion(this.updateToVersion);
        if (running.compareTo(released) < 0) {
            LOGGER.debug("Upgrade recommended");
            return true;
        }
        LOGGER.debug("Upgrade not needed");
        return false;
    }

    protected String getCurrentReleaseVersion() {
        try {
            String str = this.settings.getString("engine.version.url", "https://dependency-check.github.io/DependencyCheck/current.txt");
            URL url = new URL(str);
            String releaseVersion = null;
            releaseVersion = Downloader.getInstance().fetchContent(url, StandardCharsets.UTF_8);
            return releaseVersion.trim();
        }
        catch (TooManyRequestsException ex) {
            LOGGER.debug("Unable to retrieve current release version of dependency-check - downloader failed on HTTP 429 Too many requests");
        }
        catch (ResourceNotFoundException ex) {
            LOGGER.debug("Unable to retrieve current release version of dependency-check - downloader  failed on HTTP 404 ResourceNotFound");
        }
        catch (MalformedURLException ex) {
            LOGGER.debug("Unable to retrieve current release version of dependency-check - malformed url?");
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to retrieve current release version of dependency-check - i/o exception");
        }
        return null;
    }

    @Override
    public boolean purge(Engine engine) {
        return true;
    }
}

