/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.xml.hints.HintParseException;
import org.owasp.dependencycheck.xml.hints.HintParser;
import org.owasp.dependencycheck.xml.hints.HintRule;
import org.owasp.dependencycheck.xml.hints.Hints;
import org.owasp.dependencycheck.xml.hints.VendorDuplicatingHintRule;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class HintAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HintAnalyzer.class);
    private static final String HINT_RULE_FILE_NAME = "dependencycheck-base-hint.xml";
    private Hints hints;
    private static final String ANALYZER_NAME = "Hint Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_IDENTIFIER_ANALYSIS;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.hint.enabled";
    }

    @Override
    public void initializeAnalyzer() throws InitializationException {
        try {
            this.loadHintRules();
        }
        catch (HintParseException ex) {
            LOGGER.debug("Unable to parse hint file", (Throwable)ex);
            throw new InitializationException("Unable to parse the hint file", ex);
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        for (HintRule hint : this.hints.getHintRules()) {
            boolean matchFound = false;
            for (Evidence given : hint.getGivenVendor()) {
                if (!dependency.getVendorEvidence().getEvidence().contains(given)) continue;
                matchFound = true;
                break;
            }
            if (!matchFound) {
                for (Evidence given : hint.getGivenProduct()) {
                    if (!dependency.getProductEvidence().getEvidence().contains(given)) continue;
                    matchFound = true;
                    break;
                }
            }
            if (!matchFound) {
                for (Evidence given : hint.getGivenVersion()) {
                    if (!dependency.getVersionEvidence().getEvidence().contains(given)) continue;
                    matchFound = true;
                    break;
                }
            }
            if (!matchFound) {
                for (PropertyType pt : hint.getFilenames()) {
                    if (!pt.matches(dependency.getFileName())) continue;
                    matchFound = true;
                    break;
                }
            }
            if (!matchFound) continue;
            for (Evidence e : hint.getAddVendor()) {
                dependency.getVendorEvidence().addEvidence(e);
            }
            for (Evidence e : hint.getAddProduct()) {
                dependency.getProductEvidence().addEvidence(e);
            }
            for (Evidence e : hint.getAddVersion()) {
                dependency.getVersionEvidence().addEvidence(e);
            }
            for (Evidence e : hint.getRemoveVendor()) {
                if (!dependency.getVendorEvidence().getEvidence().contains(e)) continue;
                dependency.getVendorEvidence().getEvidence().remove(e);
            }
            for (Evidence e : hint.getRemoveProduct()) {
                if (!dependency.getProductEvidence().getEvidence().contains(e)) continue;
                dependency.getProductEvidence().getEvidence().remove(e);
            }
            for (Evidence e : hint.getRemoveVersion()) {
                if (!dependency.getVersionEvidence().getEvidence().contains(e)) continue;
                dependency.getVersionEvidence().getEvidence().remove(e);
            }
        }
        Iterator<Evidence> itr = dependency.getVendorEvidence().iterator();
        ArrayList<Evidence> newEntries = new ArrayList<Evidence>();
        while (itr.hasNext()) {
            Evidence e = itr.next();
            for (VendorDuplicatingHintRule dhr : this.hints.getVendorDuplicatingHintRules()) {
                if (!dhr.getValue().equalsIgnoreCase(e.getValue(false))) continue;
                newEntries.add(new Evidence(e.getSource() + " (hint)", e.getName(), dhr.getDuplicate(), e.getConfidence()));
            }
        }
        for (Evidence e : newEntries) {
            dependency.getVendorEvidence().addEvidence(e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadHintRules() throws HintParseException {
        HintParser parser = new HintParser();
        File file = null;
        try {
            this.hints = parser.parseHints(org.owasp.dependencycheck.utils.FileUtils.getResourceAsStream((String)HINT_RULE_FILE_NAME));
        }
        catch (HintParseException | SAXException ex) {
            LOGGER.error("Unable to parse the base hint data file");
            LOGGER.debug("Unable to parse the base hint data file", (Throwable)ex);
        }
        String filePath = Settings.getString((String)"hints.file");
        if (filePath == null) {
            return;
        }
        boolean deleteTempFile = false;
        try {
            block31: {
                Pattern uriRx = Pattern.compile("^(https?|file)\\:.*", 2);
                if (uriRx.matcher(filePath).matches()) {
                    deleteTempFile = true;
                    file = org.owasp.dependencycheck.utils.FileUtils.getTempFile((String)"hint", (String)"xml");
                    URL url = new URL(filePath);
                    try {
                        Downloader.fetchFile((URL)url, (File)file, (boolean)false);
                    }
                    catch (DownloadFailedException ex) {
                        Downloader.fetchFile((URL)url, (File)file, (boolean)true);
                    }
                } else {
                    file = new File(filePath);
                    if (!file.exists()) {
                        try (InputStream fromClasspath = org.owasp.dependencycheck.utils.FileUtils.getResourceAsStream((String)filePath);){
                            if (fromClasspath == null) break block31;
                            deleteTempFile = true;
                            file = org.owasp.dependencycheck.utils.FileUtils.getTempFile((String)"hint", (String)"xml");
                            try {
                                FileUtils.copyInputStreamToFile((InputStream)fromClasspath, (File)file);
                            }
                            catch (IOException ex) {
                                throw new HintParseException("Unable to locate hints file in classpath", ex);
                            }
                        }
                    }
                }
            }
            if (file != null) {
                try {
                    Hints newHints = parser.parseHints(file);
                    this.hints.getHintRules().addAll(newHints.getHintRules());
                    this.hints.getVendorDuplicatingHintRules().addAll(newHints.getVendorDuplicatingHintRules());
                    LOGGER.debug("{} hint rules were loaded.", (Object)this.hints.getHintRules().size());
                    LOGGER.debug("{} duplicating hint rules were loaded.", (Object)this.hints.getVendorDuplicatingHintRules().size());
                }
                catch (HintParseException ex) {
                    LOGGER.warn("Unable to parse hint rule xml file '{}'", (Object)file.getPath());
                    LOGGER.warn(ex.getMessage());
                    LOGGER.debug("", (Throwable)ex);
                    throw ex;
                }
            }
            if (!deleteTempFile) return;
            if (file == null) return;
        }
        catch (DownloadFailedException ex) {
            try {
                throw new HintParseException("Unable to fetch the configured hint file", ex);
                catch (MalformedURLException ex2) {
                    throw new HintParseException("Configured hint file has an invalid URL", ex2);
                }
                catch (IOException ex3) {
                    throw new HintParseException("Unable to create temp file for hints", ex3);
                }
            }
            catch (Throwable throwable) {
                if (!deleteTempFile) throw throwable;
                if (file == null) throw throwable;
                org.owasp.dependencycheck.utils.FileUtils.delete(file);
                throw throwable;
            }
        }
        org.owasp.dependencycheck.utils.FileUtils.delete((File)file);
    }
}

