/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.data.cpe.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerableSoftware
extends IndexEntry
implements Serializable,
Comparable<VulnerableSoftware> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VulnerableSoftware.class);
    private static final long serialVersionUID = 307319490326651052L;
    private String previousVersion;
    private String name;
    private String version;
    private String update;
    private String edition;

    public void setCpe(String cpe) {
        try {
            this.parseName(cpe);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.warn("Character encoding is unsupported for CPE '{}'.", (Object)cpe);
            LOGGER.debug("", (Throwable)ex);
            this.setName(cpe);
        }
    }

    @Override
    public void parseName(String cpeName) throws UnsupportedEncodingException {
        this.name = cpeName;
        if (cpeName != null && cpeName.length() > 7) {
            String cpeNameWithoutPrefix = cpeName.substring(7);
            String[] data = StringUtils.split((String)cpeNameWithoutPrefix, (char)':');
            if (data.length >= 1) {
                this.setVendor(this.urlDecode(data[0]));
            }
            if (data.length >= 2) {
                this.setProduct(this.urlDecode(data[1]));
            }
            if (data.length >= 3) {
                this.version = this.urlDecode(data[2]);
            }
            if (data.length >= 4) {
                this.update = this.urlDecode(data[3]);
            }
            if (data.length >= 5) {
                this.edition = this.urlDecode(data[4]);
            }
        }
    }

    public boolean hasPreviousVersion() {
        return this.previousVersion != null;
    }

    public String getPreviousVersion() {
        return this.previousVersion;
    }

    public void setPreviousVersion(String previousVersion) {
        this.previousVersion = previousVersion;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VulnerableSoftware other = (VulnerableSoftware)obj;
        return !(this.name != null ? !this.name.equals(other.getName()) : other.getName() != null);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return "VulnerableSoftware{" + this.name + "[" + this.previousVersion + "]}";
    }

    @Override
    public int compareTo(VulnerableSoftware vs) {
        String[] right;
        int max;
        int result = 0;
        String[] left = StringUtils.split((String)this.name, (char)':');
        int n = max = left.length <= (right = StringUtils.split((String)vs.getName(), (char)':')).length ? left.length : right.length;
        if (max > 0) {
            for (int i = 0; result == 0 && i < max; ++i) {
                String[] subRight;
                int subMax;
                String[] subLeft = left[i].split("(\\.|-)");
                int n2 = subMax = subLeft.length <= (subRight = right[i].split("(\\.|-)")).length ? subLeft.length : subRight.length;
                if (subMax > 0) {
                    for (int x = 0; result == 0 && x < subMax; ++x) {
                        if (VulnerableSoftware.isPositiveInteger(subLeft[x]) && VulnerableSoftware.isPositiveInteger(subRight[x])) {
                            try {
                                result = Long.valueOf(subLeft[x]).compareTo(Long.valueOf(subRight[x]));
                            }
                            catch (NumberFormatException ex) {
                                if (subLeft[x].equalsIgnoreCase(subRight[x])) continue;
                                result = subLeft[x].compareToIgnoreCase(subRight[x]);
                            }
                            continue;
                        }
                        result = subLeft[x].compareToIgnoreCase(subRight[x]);
                    }
                    if (result != 0) continue;
                    if (subLeft.length > subRight.length) {
                        result = 2;
                    }
                    if (subRight.length <= subLeft.length) continue;
                    result = -2;
                    continue;
                }
                result = left[i].compareToIgnoreCase(right[i]);
            }
            if (result == 0) {
                if (left.length > right.length) {
                    result = 2;
                }
                if (right.length > left.length) {
                    result = -2;
                }
            }
        } else {
            result = this.getName().compareToIgnoreCase(vs.getName());
        }
        return result;
    }

    protected static boolean isPositiveInteger(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.charAt(0) == '0' && str.length() > 1) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUpdate() {
        return this.update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    private String urlDecode(String string) {
        String result;
        String text = string.replace("+", "%2B");
        try {
            result = URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            try {
                result = URLDecoder.decode(text, "ASCII");
            }
            catch (UnsupportedEncodingException ex1) {
                result = this.defaultUrlDecode(text);
            }
        }
        return result;
    }

    private String defaultUrlDecode(String text) {
        return URLDecoder.decode(text);
    }
}

