/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.Retired;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AnalyzerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerService.class);
    private final ServiceLoader<Analyzer> service;
    private final Settings settings;

    public AnalyzerService(ClassLoader classLoader, Settings settings) {
        this.service = ServiceLoader.load(Analyzer.class, classLoader);
        this.settings = settings;
    }

    public List<Analyzer> getAnalyzers() {
        return this.getAnalyzers(AnalysisPhase.values());
    }

    public List<Analyzer> getAnalyzers(AnalysisPhase ... phases) {
        return this.getAnalyzers(Arrays.asList(phases));
    }

    private List<Analyzer> getAnalyzers(List<AnalysisPhase> phases) {
        ArrayList<Analyzer> analyzers = new ArrayList<Analyzer>();
        Iterator<Analyzer> iterator = this.service.iterator();
        boolean experimentalEnabled = false;
        boolean retiredEnabled = false;
        try {
            experimentalEnabled = this.settings.getBoolean("analyzer.experimental.enabled", false);
            retiredEnabled = this.settings.getBoolean("analyzer.retired.enabled", false);
        }
        catch (InvalidSettingException ex) {
            LOGGER.error("invalid experimental or retired setting", (Throwable)ex);
        }
        while (iterator.hasNext()) {
            Analyzer a = iterator.next();
            if (!phases.contains((Object)a.getAnalysisPhase()) || !experimentalEnabled && a.getClass().isAnnotationPresent(Experimental.class) || !retiredEnabled && a.getClass().isAnnotationPresent(Retired.class)) continue;
            LOGGER.debug("Loaded Analyzer {}", (Object)a.getName());
            analyzers.add(a);
        }
        return analyzers;
    }
}

