/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nsp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.net.ssl.SSLHandshakeException;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.data.nsp.Advisory;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NspSearch {
    private final URL nspCheckUrl;
    private final boolean useProxy;
    private final Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(NspSearch.class);

    public NspSearch(Settings settings) throws MalformedURLException {
        String searchUrl = settings.getString("analyzer.nsp.url", "https://api.nodesecurity.io/check");
        LOGGER.debug("NSP Search URL: {}", (Object)searchUrl);
        this.nspCheckUrl = new URL(searchUrl);
        this.settings = settings;
        if (null != settings.getString("proxy.server")) {
            this.useProxy = true;
            LOGGER.debug("Using proxy");
        } else {
            this.useProxy = false;
            LOGGER.debug("Not using proxy");
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<Advisory> submitPackage(JsonObject packageJson) throws SearchException, IOException {
        try {
            result = new ArrayList<Advisory>();
            packageDatabytes = packageJson.toString().getBytes(StandardCharsets.UTF_8);
            factory = new URLConnectionFactory(this.settings);
            conn = factory.createHttpURLConnection(this.nspCheckUrl, this.useProxy);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("X-NSP-VERSION", "2.6.2");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Content-Length", Integer.toString(packageDatabytes.length));
            conn.connect();
            os = new BufferedOutputStream(conn.getOutputStream());
            var7_9 = null;
            try {
                os.write(packageDatabytes);
                os.flush();
            }
            catch (Throwable var8_11) {
                var7_9 = var8_11;
                throw var8_11;
            }
            finally {
                if (os != null) {
                    if (var7_9 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable var8_10) {
                            var7_9.addSuppressed(var8_10);
                        }
                    } else {
                        os.close();
                    }
                }
            }
            switch (conn.getResponseCode()) {
                case 200: {
                    in = new BufferedInputStream(conn.getInputStream());
                    var7_9 = null;
                    jsonReader = Json.createReader((InputStream)in);
                    var9_16 = null;
                    try {
                        array = jsonReader.readArray();
                        if (array != null) {
                            for (i = 0; i < array.size(); ++i) {
                                object = array.getJsonObject(i);
                                advisory = new Advisory();
                                advisory.setId(object.getInt("id"));
                                advisory.setUpdatedAt(object.getString("updated_at", null));
                                advisory.setCreatedAt(object.getString("created_at", null));
                                advisory.setPublishDate(object.getString("publish_date", null));
                                advisory.setOverview(object.getString("overview"));
                                advisory.setRecommendation(object.getString("recommendation", null));
                                advisory.setCvssVector(object.getString("cvss_vector", null));
                                if (((JsonValue)object.get((Object)"cvss_score")).getValueType() != JsonValue.ValueType.NULL) {
                                    advisory.setCvssScore(Float.parseFloat(object.getJsonNumber("cvss_score").toString()));
                                } else {
                                    advisory.setCvssScore(-1.0f);
                                }
                                advisory.setModule(object.getString("module", null));
                                advisory.setVersion(object.getString("version", null));
                                advisory.setVulnerableVersions(object.getString("vulnerable_versions", null));
                                advisory.setPatchedVersions(object.getString("patched_versions", null));
                                advisory.setTitle(object.getString("title", null));
                                advisory.setAdvisory(object.getString("advisory", null));
                                jsonPath = object.getJsonArray("path");
                                stringPath = new ArrayList<String>();
                                for (j = 0; j < jsonPath.size(); ++j) {
                                    stringPath.add(jsonPath.getString(j));
                                }
                                advisory.setPath(stringPath.toArray(new String[stringPath.size()]));
                                result.add(advisory);
                            }
                        }
                    }
                    catch (Throwable var10_20) {
                        var9_16 = var10_20;
                        throw var10_20;
                    }
                    finally {
                        if (jsonReader != null) {
                            if (var9_16 != null) {
                                try {
                                    jsonReader.close();
                                }
                                catch (Throwable var10_19) {
                                    var9_16.addSuppressed(var10_19);
                                }
                            } else {
                                jsonReader.close();
                            }
                        }
                    }
                    if (in == null) break;
                    if (var7_9 == null) ** GOTO lbl97
                    try {
                        in.close();
                    }
                    catch (Throwable var8_13) {
                        var7_9.addSuppressed(var8_13);
                    }
                    break;
lbl97:
                    // 1 sources

                    in.close();
                    break;
                    catch (Throwable var8_14) {
                        try {
                            var7_9 = var8_14;
                            throw var8_14;
                        }
                        catch (Throwable var19_29) {
                            if (in != null) {
                                if (var7_9 != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable var20_30) {
                                        var7_9.addSuppressed(var20_30);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                            throw var19_29;
                        }
                    }
                }
                case 400: {
                    NspSearch.LOGGER.debug("Invalid payload submitted to Node Security Platform. Received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
                    throw new SearchException("Could not perform NSP analysis. Invalid payload submitted to Node Security Platform.");
                }
                default: {
                    NspSearch.LOGGER.debug("Could not connect to Node Security Platform. Received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
                    throw new IOException("Could not connect to Node Security Platform");
                }
            }
            return result;
        }
        catch (IOException ex) {
            if (ex instanceof SSLHandshakeException && ex.getMessage().contains("unable to find valid certification path to requested target")) {
                msg = String.format("Unable to connect to '%s' - the Java trust store does not contain a trusted root for the cert.  Please see https://github.com/jeremylong/InstallCert for one method of updating the trusted certificates.", new Object[]{this.nspCheckUrl});
                throw new URLConnectionFailureException(msg, (Throwable)ex);
            }
            throw ex;
        }
    }
}

