/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.processing;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.CvssV2;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.processing.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

public class BundlerAuditProcessor
extends Processor<InputStream> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundlerAuditProcessor.class);
    private final Dependency gemDependency;
    private final Engine engine;
    private IOException ioException;
    private CpeValidationException cpeException;

    public BundlerAuditProcessor(Dependency gemDependency, Engine engine) {
        this.gemDependency = gemDependency;
        this.engine = engine;
    }

    public void close() throws IOException, CpeValidationException {
        if (this.ioException != null) {
            this.addSuppressedExceptions(this.ioException, new Throwable[]{this.cpeException});
            throw this.ioException;
        }
        if (this.cpeException != null) {
            throw this.cpeException;
        }
    }

    public void run() {
        String parentName = this.gemDependency.getActualFile().getParentFile().getName();
        String fileName = this.gemDependency.getFileName();
        String filePath = this.gemDependency.getFilePath();
        Dependency dependency = null;
        Vulnerability vulnerability = null;
        String gem = null;
        HashMap<String, Dependency> map = new HashMap<String, Dependency>();
        boolean appendToDescription = false;
        try (InputStreamReader ir = new InputStreamReader((InputStream)this.getInput(), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(ir);){
            String nextLine;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("Name: ")) {
                    appendToDescription = false;
                    gem = nextLine.substring("Name: ".length());
                    if (!map.containsKey(gem)) {
                        map.put(gem, this.createDependencyForGem(this.engine, parentName, fileName, filePath, gem));
                    }
                    dependency = (Dependency)map.get(gem);
                    LOGGER.debug("bundle-audit ({}): {}", (Object)parentName, (Object)nextLine);
                    continue;
                }
                if (nextLine.startsWith("Version: ")) {
                    vulnerability = this.createVulnerability(parentName, dependency, gem, nextLine);
                    continue;
                }
                if (nextLine.startsWith("Advisory: ") || nextLine.startsWith("CVE: ")) {
                    this.setVulnerabilityName(parentName, dependency, vulnerability, nextLine);
                    continue;
                }
                if (nextLine.startsWith("Criticality: ")) {
                    this.addCriticalityToVulnerability(parentName, vulnerability, nextLine);
                    continue;
                }
                if (nextLine.startsWith("URL: ")) {
                    this.addReferenceToVulnerability(parentName, vulnerability, nextLine);
                    continue;
                }
                if (nextLine.startsWith("Description:") || nextLine.startsWith("Title:")) {
                    appendToDescription = true;
                    if (null == vulnerability) continue;
                    vulnerability.setDescription("*** Vulnerability obtained from bundle-audit verbose report. Title link may not work. CPE below is guessed. CVSS score is estimated (-1.0  indicates unknown). See link below for full details. *** ");
                    continue;
                }
                if (!appendToDescription || null == vulnerability) continue;
                vulnerability.setDescription(vulnerability.getDescription() + nextLine + "\n");
            }
        }
        catch (IOException ex) {
            this.ioException = ex;
        }
        catch (CpeValidationException ex) {
            this.cpeException = ex;
        }
    }

    private void setVulnerabilityName(String parentName, Dependency dependency, Vulnerability vulnerability, String nextLine) {
        String advisory = nextLine.startsWith("CVE: ") ? nextLine.substring("CVE: ".length()) : nextLine.substring("Advisory: ".length());
        if (null != vulnerability) {
            vulnerability.setName(advisory);
        }
        if (null != dependency) {
            dependency.addVulnerability(vulnerability);
        }
        LOGGER.debug("bundle-audit ({}): {}", (Object)parentName, (Object)nextLine);
    }

    private void addReferenceToVulnerability(String parentName, Vulnerability vulnerability, String nextLine) {
        String url = nextLine.substring("URL: ".length());
        if (null != vulnerability) {
            Reference ref = new Reference();
            ref.setName(vulnerability.getName());
            ref.setSource("bundle-audit");
            ref.setUrl(url);
            vulnerability.getReferences().add(ref);
        }
        LOGGER.debug("bundle-audit ({}): {}", (Object)parentName, (Object)nextLine);
    }

    private void addCriticalityToVulnerability(String parentName, Vulnerability vulnerability, String nextLine) {
        if (null != vulnerability) {
            String criticality = nextLine.substring("Criticality: ".length()).trim();
            float score = -1.0f;
            Vulnerability v = null;
            CveDB cvedb = this.engine.getDatabase();
            if (cvedb != null) {
                try {
                    v = cvedb.getVulnerability(vulnerability.getName());
                }
                catch (DatabaseException ex) {
                    LOGGER.debug("Unable to look up vulnerability {}", (Object)vulnerability.getName());
                }
            }
            if (v != null && (v.getCvssV2() != null || v.getCvssV3() != null)) {
                if (v.getCvssV2() != null) {
                    vulnerability.setCvssV2(v.getCvssV2());
                }
                if (v.getCvssV3() != null) {
                    vulnerability.setCvssV3(v.getCvssV3());
                }
            } else {
                if ("High".equalsIgnoreCase(criticality)) {
                    score = 8.5f;
                } else if ("Medium".equalsIgnoreCase(criticality)) {
                    score = 5.5f;
                } else if ("Low".equalsIgnoreCase(criticality)) {
                    score = 2.0f;
                }
                vulnerability.setCvssV2(new CvssV2(score, "-", "-", "-", "-", "-", "-", criticality));
            }
        }
        LOGGER.debug("bundle-audit ({}): {}", (Object)parentName, (Object)nextLine);
    }

    private Vulnerability createVulnerability(String parentName, Dependency dependency, String gem, String nextLine) throws CpeValidationException {
        Vulnerability vulnerability = null;
        if (null != dependency) {
            String version = nextLine.substring("Version: ".length());
            dependency.addEvidence(EvidenceType.VERSION, "bundler-audit", "Version", version, Confidence.HIGHEST);
            dependency.setVersion(version);
            dependency.setName(gem);
            try {
                PackageURL purl = PackageURLBuilder.aPackageURL().withType("gem").withName(dependency.getName()).withVersion(dependency.getVersion()).build();
                dependency.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to build package url for python", (Throwable)ex);
                GenericIdentifier id = new GenericIdentifier("gem:" + dependency.getName() + "@" + dependency.getVersion(), Confidence.HIGHEST);
                dependency.addSoftwareIdentifier(id);
            }
            vulnerability = new Vulnerability();
            vulnerability.setSource(Vulnerability.Source.BUNDLEAUDIT);
            VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder();
            VulnerableSoftware vs = builder.part(Part.APPLICATION).vendor(gem).product(String.format("%s_project", gem)).version(version).build();
            vulnerability.addVulnerableSoftware(vs);
            vulnerability.setMatchedVulnerableSoftware(vs);
            vulnerability.setCvssV2(new CvssV2(-1.0f, "-", "-", "-", "-", "-", "-", "unknown"));
        }
        LOGGER.debug("bundle-audit ({}): {}", (Object)parentName, (Object)nextLine);
        return vulnerability;
    }

    private Dependency createDependencyForGem(Engine engine, String parentName, String fileName, String filePath, String gem) throws IOException {
        File gemFile;
        try {
            gemFile = File.createTempFile(gem, "_Gemfile.lock", engine.getSettings().getTempDirectory());
        }
        catch (IOException ioe) {
            throw new IOException("Unable to create temporary gem file");
        }
        String displayFileName = String.format("%s%c%s:%s", parentName, Character.valueOf(File.separatorChar), fileName, gem);
        FileUtils.write((File)gemFile, (CharSequence)displayFileName, (Charset)Charset.defaultCharset());
        Dependency dependency = new Dependency(gemFile);
        dependency.setEcosystem("ruby");
        dependency.addEvidence(EvidenceType.PRODUCT, "bundler-audit", "Name", gem, Confidence.HIGHEST);
        dependency.setDisplayFileName(displayFileName);
        dependency.setFileName(fileName);
        dependency.setFilePath(filePath);
        dependency.setSha1sum(Checksum.getSHA1Checksum((String)displayFileName));
        engine.addDependency(dependency);
        return dependency;
    }
}

