/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class CMakeAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "native";
    private static final Logger LOGGER = LoggerFactory.getLogger(CMakeAnalyzer.class);
    private static final int REGEX_OPTIONS = 42;
    private static final Pattern PROJECT_VERSION = Pattern.compile("^\\s*set\\s*\\(\\s*VERSION\\s*\"([^\"]*)\"\\)", 42);
    private static final Pattern SET_VAR_REGEX = Pattern.compile("^\\s*set\\s*\\(\\s*([a-zA-Z\\d_\\-]*)\\s+\"?([a-zA-Z\\d_\\-.${}]*)\"?\\s*\\)", 42);
    private static final Pattern INL_VAR_REGEX = Pattern.compile("(\\$\\s*\\{([^}]*)\\s*})", 42);
    private static final Pattern PROJECT = Pattern.compile("^ *project *\\([ \\n]*(\\w+)[ \\n]*.*?\\)", 42);
    private static final Pattern SET_VERSION = Pattern.compile("^\\s*set\\s*\\(\\s*(\\w+)_version\\s+\"?([^\")]*)\\s*\"?\\)", 42);
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(".cmake").addFilenames("CMakeLists.txt").build();

    @Override
    public String getName() {
        return "CMake Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        File file = dependency.getActualFile();
        String name = file.getName();
        try {
            contents = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        if (StringUtils.isNotBlank((CharSequence)contents)) {
            Map<String, String> vars = this.collectDefinedVariables(contents);
            String contentsReplacer = contents;
            Matcher r = INL_VAR_REGEX.matcher(contents);
            while (r.find()) {
                boolean leastOne = false;
                if (vars.containsKey(r.group(2)) && !vars.get(r.group(2)).contains(r.group(2))) {
                    contentsReplacer = contentsReplacer.replace(r.group(1), vars.get(r.group(2)));
                    r = INL_VAR_REGEX.matcher(contentsReplacer);
                    leastOne = true;
                }
                while (r.find()) {
                    if (!vars.containsKey(r.group(2)) || vars.get(r.group(2)).contains(r.group(2))) continue;
                    contentsReplacer = contentsReplacer.replace(r.group(1), vars.get(r.group(2)));
                    r = INL_VAR_REGEX.matcher(contentsReplacer);
                    leastOne = true;
                }
                if (!leastOne) break;
                r = INL_VAR_REGEX.matcher(contentsReplacer);
            }
            String contentsReplaced = contentsReplacer;
            Matcher m = PROJECT.matcher(contentsReplaced);
            int count = 0;
            while (m.find()) {
                ++count;
                LOGGER.debug(String.format("Found project command match with %d groups: %s", m.groupCount(), m.group(0)));
                String group = m.group(1);
                LOGGER.debug("Group 1: {}", (Object)group);
                dependency.addEvidence(EvidenceType.PRODUCT, name, "Project", group, Confidence.HIGH);
                dependency.addEvidence(EvidenceType.VENDOR, name, "Project", group, Confidence.HIGH);
                dependency.setName(group);
                dependency.setDisplayFileName(group);
            }
            if (count > 0) {
                dependency.addEvidence(EvidenceType.VENDOR, "CmakeAnalyzer", "hint", "gnu", Confidence.MEDIUM);
            }
            LOGGER.debug("Found {} matches.", (Object)count);
            Matcher mVersion = PROJECT_VERSION.matcher(contentsReplaced);
            while (mVersion.find()) {
                LOGGER.debug(String.format("Found set version command match with %d groups: %s", mVersion.groupCount(), mVersion.group(0)));
                String group = mVersion.group(1);
                LOGGER.debug("Group 1: {}", (Object)group);
                dependency.addEvidence(EvidenceType.VERSION, name, "VERSION", group, Confidence.HIGH);
                DependencyVersion vers = DependencyVersionUtil.parseVersion(group, true);
                if (vers == null) continue;
                dependency.setVersion(vers.toString());
            }
            this.analyzeSetVersionCommand(dependency, engine, contentsReplaced);
        }
    }

    private Map<String, String> collectDefinedVariables(String contents) {
        HashMap<String, String> vars = new HashMap<String, String>();
        Matcher m = SET_VAR_REGEX.matcher(contents);
        int count = 0;
        while (m.find()) {
            ++count;
            LOGGER.debug("Found set variable command match with {} groups: {}", (Object)m.groupCount(), (Object)m.group(0));
            String name = m.group(1);
            String value = m.group(2);
            LOGGER.debug("Group 1: {}", (Object)name);
            LOGGER.debug("Group 2: {}", (Object)value);
            vars.put(name, value);
        }
        LOGGER.debug("Found {} matches.", (Object)count);
        return this.removeSelfReferences(vars);
    }

    private void analyzeSetVersionCommand(Dependency dependency, Engine engine, String contents) {
        Dependency currentDep = dependency;
        Matcher m = SET_VERSION.matcher(contents);
        int count = 0;
        while (m.find()) {
            DependencyVersion vers;
            ++count;
            LOGGER.debug("Found project command match with {} groups: {}", (Object)m.groupCount(), (Object)m.group(0));
            String product = m.group(1);
            String version = m.group(2);
            LOGGER.debug("Group 1: {}", (Object)product);
            LOGGER.debug("Group 2: {}", (Object)version);
            String aliasPrefix = "ALIASOF_";
            if (product.startsWith("ALIASOF_")) {
                product = product.replaceFirst("ALIASOF_", "");
            }
            if (product.startsWith("_")) {
                product = product.substring(1);
            }
            if (count > 1) {
                currentDep = new Dependency(dependency.getActualFile(), true);
                currentDep.setEcosystem(DEPENDENCY_ECOSYSTEM);
                String filePath = String.format("%s:%s", dependency.getFilePath(), product);
                currentDep.setFilePath(filePath);
                currentDep.setSha1sum(Checksum.getSHA1Checksum((String)filePath));
                currentDep.setSha256sum(Checksum.getSHA256Checksum((String)filePath));
                currentDep.setMd5sum(Checksum.getMD5Checksum((String)filePath));
                engine.addDependency(currentDep);
            }
            String source = currentDep.getFileName();
            currentDep.addEvidence(EvidenceType.PRODUCT, source, "Product", product, Confidence.MEDIUM);
            currentDep.addEvidence(EvidenceType.VENDOR, source, "Vendor", product, Confidence.MEDIUM);
            currentDep.addEvidence(EvidenceType.VERSION, source, "Version", version, Confidence.MEDIUM);
            if (product.toLowerCase().endsWith("lib")) {
                currentDep = new Dependency(dependency.getActualFile(), true);
                currentDep.setEcosystem(DEPENDENCY_ECOSYSTEM);
                String filePath = String.format("%s:%s", dependency.getFilePath(), product);
                currentDep.setFilePath(filePath);
                currentDep.setSha1sum(Checksum.getSHA1Checksum((String)filePath));
                currentDep.setSha256sum(Checksum.getSHA256Checksum((String)filePath));
                currentDep.setMd5sum(Checksum.getMD5Checksum((String)filePath));
                engine.addDependency(currentDep);
                product = "lib" + product.toLowerCase().substring(0, product.length() - 3);
                currentDep.addEvidence(EvidenceType.PRODUCT, source, "Product", product, Confidence.MEDIUM);
                currentDep.addEvidence(EvidenceType.VENDOR, source, "Vendor", product, Confidence.MEDIUM);
                currentDep.addEvidence(EvidenceType.VERSION, source, "Version", version, Confidence.MEDIUM);
            }
            if (StringUtils.isBlank((CharSequence)currentDep.getName())) {
                currentDep.setName(product);
                currentDep.setDisplayFileName(product);
            }
            if (!StringUtils.isBlank((CharSequence)currentDep.getVersion()) || (vers = DependencyVersionUtil.parseVersion(version, true)) == null) continue;
            currentDep.setVersion(vers.toString());
        }
        LOGGER.debug("Found {} matches.", (Object)count);
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.cmake.enabled";
    }

    Map<String, String> removeSelfReferences(Map<String, String> vars) {
        HashMap<String, String> resolvedVars = new HashMap<String, String>();
        vars.forEach((key, value) -> {
            if (!this.isVariableSelfReferencing(vars, (String)key)) {
                resolvedVars.put((String)key, (String)value);
            }
        });
        return resolvedVars;
    }

    private boolean isVariableSelfReferencing(Map<String, String> vars, String key) {
        Matcher matcher;
        ArrayList<String> resolutionChain = new ArrayList<String>();
        resolutionChain.add(key);
        String nextKey = (String)resolutionChain.get(0);
        while ((matcher = INL_VAR_REGEX.matcher(vars.get(nextKey))).find()) {
            nextKey = matcher.group(2);
            resolutionChain.add(nextKey);
            if (Objects.nonNull(nextKey) && vars.containsKey(nextKey) && !key.equals(nextKey)) continue;
        }
        return resolutionChain.size() != 1 && key.equals(nextKey);
    }
}

