/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"attackVector", "attackComplexity", "privilegesRequired", "userInteraction", "scope", "confidentialityImpact", "integrityImpact", "availabilityImpact", "baseScore", "baseSeverity"})
public class CvssV3X {
    @JsonProperty(value="attackVector")
    private AttackVectorType attackVector;
    @JsonProperty(value="attackComplexity")
    private AttackComplexityType attackComplexity;
    @JsonProperty(value="privilegesRequired")
    private PrivilegesRequiredType privilegesRequired;
    @JsonProperty(value="userInteraction")
    private UserInteractionType userInteraction;
    @JsonProperty(value="scope")
    private ScopeType scope;
    @JsonProperty(value="confidentialityImpact")
    private CiaType confidentialityImpact;
    @JsonProperty(value="integrityImpact")
    private CiaType integrityImpact;
    @JsonProperty(value="availabilityImpact")
    private CiaType availabilityImpact;
    @JsonProperty(value="baseScore")
    private Double baseScore;
    @JsonProperty(value="baseSeverity")
    private SeverityType baseSeverity;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="attackVector")
    public AttackVectorType getAttackVector() {
        return this.attackVector;
    }

    @JsonProperty(value="attackVector")
    public void setAttackVector(AttackVectorType attackVector) {
        this.attackVector = attackVector;
    }

    @JsonProperty(value="attackComplexity")
    public AttackComplexityType getAttackComplexity() {
        return this.attackComplexity;
    }

    @JsonProperty(value="attackComplexity")
    public void setAttackComplexity(AttackComplexityType attackComplexity) {
        this.attackComplexity = attackComplexity;
    }

    @JsonProperty(value="privilegesRequired")
    public PrivilegesRequiredType getPrivilegesRequired() {
        return this.privilegesRequired;
    }

    @JsonProperty(value="privilegesRequired")
    public void setPrivilegesRequired(PrivilegesRequiredType privilegesRequired) {
        this.privilegesRequired = privilegesRequired;
    }

    @JsonProperty(value="userInteraction")
    public UserInteractionType getUserInteraction() {
        return this.userInteraction;
    }

    @JsonProperty(value="userInteraction")
    public void setUserInteraction(UserInteractionType userInteraction) {
        this.userInteraction = userInteraction;
    }

    @JsonProperty(value="scope")
    public ScopeType getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    public void setScope(ScopeType scope) {
        this.scope = scope;
    }

    @JsonProperty(value="confidentialityImpact")
    public CiaType getConfidentialityImpact() {
        return this.confidentialityImpact;
    }

    @JsonProperty(value="confidentialityImpact")
    public void setConfidentialityImpact(CiaType confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    @JsonProperty(value="integrityImpact")
    public CiaType getIntegrityImpact() {
        return this.integrityImpact;
    }

    @JsonProperty(value="integrityImpact")
    public void setIntegrityImpact(CiaType integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    @JsonProperty(value="availabilityImpact")
    public CiaType getAvailabilityImpact() {
        return this.availabilityImpact;
    }

    @JsonProperty(value="availabilityImpact")
    public void setAvailabilityImpact(CiaType availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    @JsonProperty(value="baseScore")
    public Double getBaseScore() {
        return this.baseScore;
    }

    @JsonProperty(value="baseScore")
    public void setBaseScore(Double baseScore) {
        this.baseScore = baseScore;
    }

    @JsonProperty(value="baseSeverity")
    public SeverityType getBaseSeverity() {
        return this.baseSeverity;
    }

    @JsonProperty(value="baseSeverity")
    public void setBaseSeverity(SeverityType baseSeverity) {
        this.baseSeverity = baseSeverity;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CvssV3X.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attackVector");
        sb.append('=');
        sb.append(this.attackVector == null ? "<null>" : this.attackVector);
        sb.append(',');
        sb.append("attackComplexity");
        sb.append('=');
        sb.append(this.attackComplexity == null ? "<null>" : this.attackComplexity);
        sb.append(',');
        sb.append("privilegesRequired");
        sb.append('=');
        sb.append(this.privilegesRequired == null ? "<null>" : this.privilegesRequired);
        sb.append(',');
        sb.append("userInteraction");
        sb.append('=');
        sb.append(this.userInteraction == null ? "<null>" : this.userInteraction);
        sb.append(',');
        sb.append("scope");
        sb.append('=');
        sb.append(this.scope == null ? "<null>" : this.scope);
        sb.append(',');
        sb.append("confidentialityImpact");
        sb.append('=');
        sb.append(this.confidentialityImpact == null ? "<null>" : this.confidentialityImpact);
        sb.append(',');
        sb.append("integrityImpact");
        sb.append('=');
        sb.append(this.integrityImpact == null ? "<null>" : this.integrityImpact);
        sb.append(',');
        sb.append("availabilityImpact");
        sb.append('=');
        sb.append(this.availabilityImpact == null ? "<null>" : this.availabilityImpact);
        sb.append(',');
        sb.append("baseScore");
        sb.append('=');
        sb.append(this.baseScore == null ? "<null>" : this.baseScore);
        sb.append(',');
        sb.append("baseSeverity");
        sb.append('=');
        sb.append(this.baseSeverity == null ? "<null>" : this.baseSeverity);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.baseSeverity == null ? 0 : this.baseSeverity.hashCode());
        result = result * 31 + (this.confidentialityImpact == null ? 0 : this.confidentialityImpact.hashCode());
        result = result * 31 + (this.attackComplexity == null ? 0 : this.attackComplexity.hashCode());
        result = result * 31 + (this.scope == null ? 0 : this.scope.hashCode());
        result = result * 31 + (this.attackVector == null ? 0 : this.attackVector.hashCode());
        result = result * 31 + (this.availabilityImpact == null ? 0 : this.availabilityImpact.hashCode());
        result = result * 31 + (this.integrityImpact == null ? 0 : this.integrityImpact.hashCode());
        result = result * 31 + (this.privilegesRequired == null ? 0 : this.privilegesRequired.hashCode());
        result = result * 31 + (this.baseScore == null ? 0 : this.baseScore.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.userInteraction == null ? 0 : this.userInteraction.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CvssV3X)) {
            return false;
        }
        CvssV3X rhs = (CvssV3X)other;
        return (this.baseSeverity == rhs.baseSeverity || this.baseSeverity != null && this.baseSeverity.equals((Object)rhs.baseSeverity)) && (this.confidentialityImpact == rhs.confidentialityImpact || this.confidentialityImpact != null && this.confidentialityImpact.equals((Object)rhs.confidentialityImpact)) && (this.attackComplexity == rhs.attackComplexity || this.attackComplexity != null && this.attackComplexity.equals((Object)rhs.attackComplexity)) && (this.scope == rhs.scope || this.scope != null && this.scope.equals((Object)rhs.scope)) && (this.attackVector == rhs.attackVector || this.attackVector != null && this.attackVector.equals((Object)rhs.attackVector)) && (this.availabilityImpact == rhs.availabilityImpact || this.availabilityImpact != null && this.availabilityImpact.equals((Object)rhs.availabilityImpact)) && (this.integrityImpact == rhs.integrityImpact || this.integrityImpact != null && this.integrityImpact.equals((Object)rhs.integrityImpact)) && (this.privilegesRequired == rhs.privilegesRequired || this.privilegesRequired != null && this.privilegesRequired.equals((Object)rhs.privilegesRequired)) && (this.baseScore == rhs.baseScore || this.baseScore != null && this.baseScore.equals(rhs.baseScore)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.userInteraction == rhs.userInteraction || this.userInteraction != null && this.userInteraction.equals((Object)rhs.userInteraction));
    }

    public static enum UserInteractionType {
        NONE("NONE"),
        REQUIRED("REQUIRED");

        private final String value;
        private static final Map<String, UserInteractionType> CONSTANTS;

        private UserInteractionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static UserInteractionType fromValue(String value) {
            UserInteractionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, UserInteractionType>();
            for (UserInteractionType c : UserInteractionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SeverityType {
        NONE("NONE"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        CRITICAL("CRITICAL");

        private final String value;
        private static final Map<String, SeverityType> CONSTANTS;

        private SeverityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SeverityType fromValue(String value) {
            SeverityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SeverityType>();
            for (SeverityType c : SeverityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ScopeType {
        UNCHANGED("UNCHANGED"),
        CHANGED("CHANGED");

        private final String value;
        private static final Map<String, ScopeType> CONSTANTS;

        private ScopeType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ScopeType fromValue(String value) {
            ScopeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ScopeType>();
            for (ScopeType c : ScopeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum PrivilegesRequiredType {
        HIGH("HIGH"),
        LOW("LOW"),
        NONE("NONE");

        private final String value;
        private static final Map<String, PrivilegesRequiredType> CONSTANTS;

        private PrivilegesRequiredType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PrivilegesRequiredType fromValue(String value) {
            PrivilegesRequiredType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PrivilegesRequiredType>();
            for (PrivilegesRequiredType c : PrivilegesRequiredType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaType {
        NONE("NONE"),
        LOW("LOW"),
        HIGH("HIGH");

        private final String value;
        private static final Map<String, CiaType> CONSTANTS;

        private CiaType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CiaType fromValue(String value) {
            CiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CiaType>();
            for (CiaType c : CiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AttackVectorType {
        NETWORK("NETWORK"),
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        LOCAL("LOCAL"),
        PHYSICAL("PHYSICAL");

        private final String value;
        private static final Map<String, AttackVectorType> CONSTANTS;

        private AttackVectorType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AttackVectorType fromValue(String value) {
            AttackVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AttackVectorType>();
            for (AttackVectorType c : AttackVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AttackComplexityType {
        HIGH("HIGH"),
        LOW("LOW");

        private final String value;
        private static final Map<String, AttackComplexityType> CONSTANTS;

        private AttackComplexityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AttackComplexityType fromValue(String value) {
            AttackComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AttackComplexityType>();
            for (AttackComplexityType c : AttackComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

