/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.BlockCoverage;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.ClassLine;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.CoverageResult;
import org.pitest.coverage.CoverageSummary;
import org.pitest.coverage.InstructionLocation;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.TestInfo;
import org.pitest.coverage.TestInfoNameComparator;
import org.pitest.functional.FCollection;
import org.pitest.testapi.Description;
import org.pitest.util.Log;

public class CoverageData
implements CoverageDatabase {
    private static final Logger LOG = Log.getLogger();
    private final Map<InstructionLocation, Set<TestInfo>> instructionCoverage;
    private final Map<BlockLocation, Set<Integer>> blocksToLines = new LinkedHashMap<BlockLocation, Set<Integer>>();
    private final Map<ClassName, Map<ClassLine, Set<TestInfo>>> lineCoverage = new LinkedHashMap<ClassName, Map<ClassLine, Set<TestInfo>>>();
    private final Map<String, Collection<ClassInfo>> classesForFile;
    private final CodeSource code;
    private final LineMap lm;
    private final List<Description> failingTestDescriptions = new ArrayList<Description>();

    public CoverageData(CodeSource code, LineMap lm) {
        this(code, lm, new LinkedHashMap<InstructionLocation, Set<TestInfo>>());
    }

    public CoverageData(CodeSource code, LineMap lm, Map<InstructionLocation, Set<TestInfo>> instructionCoverage) {
        this.instructionCoverage = instructionCoverage;
        this.code = code;
        this.lm = lm;
        this.classesForFile = FCollection.bucket((Iterable)this.code.getCode(), CoverageData.keyFromClassInfo());
    }

    @Override
    public Collection<TestInfo> getTestsForInstructionLocation(InstructionLocation location) {
        return this.instructionCoverage.get(location);
    }

    @Override
    public Collection<TestInfo> getTestsForClassLine(ClassLine classLine) {
        Collection result = this.getTestsForClassName(classLine.getClassName()).get(classLine);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public boolean allTestsGreen() {
        return this.failingTestDescriptions.isEmpty();
    }

    public int getCountFailedTests() {
        return this.failingTestDescriptions.size();
    }

    public List<Description> getFailingTestDescriptions() {
        return this.failingTestDescriptions;
    }

    @Override
    public Collection<ClassInfo> getClassInfo(Collection<ClassName> classes) {
        return this.code.getClassInfo(classes);
    }

    @Override
    public int getNumberOfCoveredLines(Collection<ClassName> mutatedClass) {
        return (Integer)FCollection.fold(this.numberCoveredLines(), (Object)0, mutatedClass);
    }

    @Override
    public Collection<TestInfo> getTestsForClass(ClassName clazz) {
        TreeSet<TestInfo> tis = new TreeSet<TestInfo>((Comparator<TestInfo>)new TestInfoNameComparator());
        tis.addAll(this.instructionCoverage.entrySet().stream().filter(this.isFor(clazz)).flatMap(this.toTests()).collect(Collectors.toList()));
        return tis;
    }

    public void calculateClassCoverage(CoverageResult cr) {
        this.checkForFailedTest(cr);
        TestInfo ti = this.createTestInfo(cr.getTestUnitDescription(), cr.getExecutionTime(), cr.getNumberOfCoveredBlocks());
        for (BlockLocation each : cr.getCoverage()) {
            for (int i = each.getFirstInsnInBlock(); i <= each.getLastInsnInBlock(); ++i) {
                this.addTestsToBlockMap(ti, new InstructionLocation(each, i));
            }
        }
    }

    private void addTestsToBlockMap(TestInfo ti, InstructionLocation each) {
        Set<TestInfo> tests = this.instructionCoverage.get(each);
        if (tests == null) {
            tests = new TreeSet<TestInfo>((Comparator<TestInfo>)new TestInfoNameComparator());
            this.instructionCoverage.put(each, tests);
        }
        tests.add(ti);
    }

    @Override
    public BigInteger getCoverageIdForClass(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> coverage = this.getTestsForClassName(clazz);
        if (coverage.isEmpty()) {
            return BigInteger.ZERO;
        }
        return this.generateCoverageNumber(coverage);
    }

    public List<BlockCoverage> createCoverage() {
        return FCollection.map(this.instructionCoverage.entrySet(), CoverageData.toBlockCoverage());
    }

    private static Function<Map.Entry<InstructionLocation, Set<TestInfo>>, BlockCoverage> toBlockCoverage() {
        return a -> new BlockCoverage(((InstructionLocation)a.getKey()).getBlockLocation(), (Collection)FCollection.map((Iterable)((Iterable)a.getValue()), (Function)TestInfo.toName()));
    }

    @Override
    public Collection<ClassInfo> getClassesForFile(String sourceFile, String packageName) {
        Collection<ClassInfo> value = this.getClassesForFileCache().get(CoverageData.keyFromSourceAndPackage(sourceFile, packageName));
        if (value == null) {
            return Collections.emptyList();
        }
        return value;
    }

    private Map<String, Collection<ClassInfo>> getClassesForFileCache() {
        return this.classesForFile;
    }

    @Override
    public CoverageSummary createSummary() {
        return new CoverageSummary(this.numberOfLines(), this.coveredLines());
    }

    private BigInteger generateCoverageNumber(Map<ClassLine, Set<TestInfo>> coverage) {
        BigInteger coverageNumber = BigInteger.ZERO;
        HashSet testClasses = new HashSet();
        FCollection.flatMapTo(coverage.values(), this.testsToClassName(), testClasses);
        for (ClassInfo each : this.code.getClassInfo(testClasses)) {
            coverageNumber = coverageNumber.add(each.getDeepHash());
        }
        return coverageNumber;
    }

    private Function<Set<TestInfo>, Iterable<ClassName>> testsToClassName() {
        return a -> FCollection.map((Iterable)a, (Function)TestInfo.toDefiningClassName());
    }

    private static Function<ClassInfo, String> keyFromClassInfo() {
        return c -> CoverageData.keyFromSourceAndPackage(c.getSourceFileName(), c.getName().getPackage().asJavaName());
    }

    private static String keyFromSourceAndPackage(String sourceFile, String packageName) {
        return packageName + " " + sourceFile;
    }

    private Collection<ClassName> allClasses() {
        return this.code.getCodeUnderTestNames();
    }

    private int numberOfLines() {
        return (Integer)FCollection.fold(this.numberLines(), (Object)0, (Iterable)this.code.getClassInfo(this.allClasses()));
    }

    private int coveredLines() {
        return (Integer)FCollection.fold(this.numberCoveredLines(), (Object)0, this.allClasses());
    }

    private BiFunction<Integer, ClassInfo, Integer> numberLines() {
        return (a, clazz) -> a + clazz.getNumberOfCodeLines();
    }

    private void checkForFailedTest(CoverageResult cr) {
        if (!cr.isGreenTest()) {
            this.recordTestFailure(cr.getTestUnitDescription());
            LOG.severe(cr.getTestUnitDescription() + " did not pass without mutation.");
        }
    }

    private TestInfo createTestInfo(Description description, int executionTime, int linesCovered) {
        Optional testee = this.code.findTestee(description.getFirstTestClass());
        return new TestInfo(description.getFirstTestClass(), description.getQualifiedName(), executionTime, testee, linesCovered);
    }

    private BiFunction<Integer, ClassName, Integer> numberCoveredLines() {
        return (a, clazz) -> a + this.getNumberOfCoveredLines((ClassName)clazz);
    }

    private int getNumberOfCoveredLines(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> map = this.getTestsForClassName(clazz);
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    private Map<ClassLine, Set<TestInfo>> getTestsForClassName(ClassName clazz) {
        Map<ClassLine, Set<TestInfo>> map = this.lineCoverage.get(clazz);
        if (map != null) {
            return map;
        }
        return this.convertInstructionCoverageToLineCoverageForClass(clazz);
    }

    private Map<ClassLine, Set<TestInfo>> convertInstructionCoverageToLineCoverageForClass(ClassName clazz) {
        List tests = FCollection.filter(this.instructionCoverage.entrySet(), this.isFor(clazz));
        LinkedHashMap<ClassLine, Set<TestInfo>> linesToTests = new LinkedHashMap<ClassLine, Set<TestInfo>>(0);
        for (Map.Entry each : tests) {
            for (int line : this.getLinesForBlock(((InstructionLocation)each.getKey()).getBlockLocation())) {
                Set<TestInfo> tis = CoverageData.getLineTestSet(clazz, linesToTests, each, line);
                tis.addAll((Collection)each.getValue());
            }
        }
        this.lineCoverage.put(clazz, linesToTests);
        return linesToTests;
    }

    private static Set<TestInfo> getLineTestSet(ClassName clazz, Map<ClassLine, Set<TestInfo>> linesToTests, Map.Entry<InstructionLocation, Set<TestInfo>> each, int line) {
        ClassLine cl = new ClassLine(clazz, line);
        Set<TestInfo> tis = linesToTests.get(cl);
        if (tis == null) {
            tis = new TreeSet<TestInfo>((Comparator<TestInfo>)new TestInfoNameComparator());
            tis.addAll((Collection<TestInfo>)each.getValue());
            linesToTests.put(new ClassLine(clazz, line), tis);
        }
        return tis;
    }

    private Set<Integer> getLinesForBlock(BlockLocation bl) {
        Set<Integer> lines = this.blocksToLines.get(bl);
        if (lines == null) {
            this.calculateLinesForBlocks(bl.getLocation().getClassName());
            lines = this.blocksToLines.get(bl);
            if (lines == null) {
                lines = Collections.emptySet();
            }
        }
        return lines;
    }

    private void calculateLinesForBlocks(ClassName className) {
        Map lines = this.lm.mapLines(className);
        this.blocksToLines.putAll(lines);
    }

    private void recordTestFailure(Description testDescription) {
        this.failingTestDescriptions.add(testDescription);
    }

    private Function<Map.Entry<InstructionLocation, Set<TestInfo>>, Stream<TestInfo>> toTests() {
        return a -> ((Set)a.getValue()).stream();
    }

    private Predicate<Map.Entry<InstructionLocation, Set<TestInfo>>> isFor(ClassName clazz) {
        return a -> ((InstructionLocation)a.getKey()).isFor(clazz);
    }
}

