/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class UnwindOperation
implements AggregationOperation,
FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private final ExposedFields.ExposedField field;
    @Nullable
    private final ExposedFields.ExposedField arrayIndex;
    private final boolean preserveNullAndEmptyArrays;

    public UnwindOperation(Field field) {
        this(new ExposedFields.ExposedField(field, true), false);
    }

    public UnwindOperation(Field field, boolean preserveNullAndEmptyArrays) {
        Assert.notNull((Object)field, (String)"Field must not be null!");
        this.field = new ExposedFields.ExposedField(field, true);
        this.arrayIndex = null;
        this.preserveNullAndEmptyArrays = preserveNullAndEmptyArrays;
    }

    public UnwindOperation(Field field, Field arrayIndex, boolean preserveNullAndEmptyArrays) {
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull((Object)arrayIndex, (String)"ArrayIndex must not be null!");
        this.field = new ExposedFields.ExposedField(field, true);
        this.arrayIndex = new ExposedFields.ExposedField(arrayIndex, true);
        this.preserveNullAndEmptyArrays = preserveNullAndEmptyArrays;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        String path = context.getReference(this.field).toString();
        if (!this.preserveNullAndEmptyArrays && this.arrayIndex == null) {
            return new Document(this.getOperator(), (Object)path);
        }
        Document unwindArgs = new Document();
        unwindArgs.put("path", (Object)path);
        if (this.arrayIndex != null) {
            unwindArgs.put("includeArrayIndex", (Object)this.arrayIndex.getName());
        }
        unwindArgs.put("preserveNullAndEmptyArrays", (Object)this.preserveNullAndEmptyArrays);
        return new Document(this.getOperator(), (Object)unwindArgs);
    }

    @Override
    public String getOperator() {
        return "$unwind";
    }

    @Override
    public ExposedFields getFields() {
        return this.arrayIndex != null ? ExposedFields.from(this.arrayIndex) : ExposedFields.from(new ExposedFields.ExposedField[0]);
    }

    public static PathBuilder newUnwind() {
        return UnwindOperationBuilder.newBuilder();
    }

    public static final class UnwindOperationBuilder
    implements PathBuilder,
    IndexBuilder,
    EmptyArraysBuilder {
        @Nullable
        private Field field;
        @Nullable
        private Field arrayIndex;

        private UnwindOperationBuilder() {
        }

        public static PathBuilder newBuilder() {
            return new UnwindOperationBuilder();
        }

        @Override
        public UnwindOperation preserveNullAndEmptyArrays() {
            if (this.arrayIndex != null) {
                return new UnwindOperation(this.field, this.arrayIndex, true);
            }
            return new UnwindOperation(this.field, true);
        }

        @Override
        public UnwindOperation skipNullAndEmptyArrays() {
            if (this.arrayIndex != null) {
                return new UnwindOperation(this.field, this.arrayIndex, false);
            }
            return new UnwindOperation(this.field, false);
        }

        @Override
        public EmptyArraysBuilder arrayIndex(String field) {
            Assert.hasText((String)field, (String)"'ArrayIndex' must not be null or empty!");
            this.arrayIndex = Fields.field(field);
            return this;
        }

        @Override
        public EmptyArraysBuilder noArrayIndex() {
            this.arrayIndex = null;
            return this;
        }

        @Override
        public UnwindOperationBuilder path(String path) {
            Assert.hasText((String)path, (String)"'Path' must not be null or empty!");
            this.field = Fields.field(path);
            return this;
        }
    }

    public static interface EmptyArraysBuilder {
        public UnwindOperation preserveNullAndEmptyArrays();

        public UnwindOperation skipNullAndEmptyArrays();
    }

    public static interface IndexBuilder {
        public EmptyArraysBuilder arrayIndex(String var1);

        public EmptyArraysBuilder noArrayIndex();
    }

    public static interface PathBuilder {
        public IndexBuilder path(String var1);
    }
}

