/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server;

import lombok.Generated;
import lombok.NonNull;
import org.springframework.hateoas.LinkRelation;
import org.springframework.lang.Nullable;
import org.springframework.plugin.core.Plugin;

public interface LinkRelationProvider
extends Plugin<LookupContext> {
    public LinkRelation getItemResourceRelFor(Class<?> var1);

    public LinkRelation getCollectionResourceRelFor(Class<?> var1);

    public boolean supports(LookupContext var1);

    public static class LookupContext {
        @NonNull
        private final Class<?> type;
        @Nullable
        private final ResourceType resourceType;

        public static LookupContext forType(Class<?> type) {
            return new LookupContext(type, null);
        }

        public static LookupContext forItemResourceRelLookup(Class<?> type) {
            return new LookupContext(type, ResourceType.ITEM);
        }

        public static LookupContext forCollectionResourceRelLookup(Class<?> type) {
            return new LookupContext(type, ResourceType.COLLECTION);
        }

        public boolean isItemRelationLookup() {
            return this.resourceType == null || ResourceType.ITEM.equals((Object)this.resourceType);
        }

        public boolean isCollectionRelationLookup() {
            return this.resourceType == null || ResourceType.COLLECTION.equals((Object)this.resourceType);
        }

        public boolean handlesType(Class<?> type) {
            return this.type.equals(type);
        }

        public String toString() {
            ResourceType resourceType = this.resourceType;
            return String.format("LookupContext for %s for %s resource relations.", this.type.getName(), resourceType == null ? "ITEM & COLLECTION" : resourceType.name());
        }

        @Generated
        private LookupContext(@NonNull Class<?> type, @Nullable ResourceType resourceType) {
            if (type == null) {
                throw new IllegalArgumentException("type is marked non-null but is null");
            }
            this.type = type;
            this.resourceType = resourceType;
        }

        @org.springframework.lang.NonNull
        @Generated
        private static LookupContext of(@NonNull Class<?> type, @Nullable ResourceType resourceType) {
            return new LookupContext(type, resourceType);
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LookupContext)) {
                return false;
            }
            LookupContext other = (LookupContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            ResourceType this$resourceType = this.resourceType;
            ResourceType other$resourceType = other.resourceType;
            return !(this$resourceType == null ? other$resourceType != null : !((Object)((Object)this$resourceType)).equals((Object)other$resourceType));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof LookupContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            ResourceType $resourceType = this.resourceType;
            result = result * 59 + ($resourceType == null ? 43 : ((Object)((Object)$resourceType)).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Class<?> getType() {
            return this.type;
        }

        private static enum ResourceType {
            ITEM,
            COLLECTION;

        }
    }
}

