/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.authentication;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class CasServiceTicketAuthenticationToken
extends AbstractAuthenticationToken {
    static final String CAS_STATELESS_IDENTIFIER = "_cas_stateless_";
    static final String CAS_STATEFUL_IDENTIFIER = "_cas_stateful_";
    private static final long serialVersionUID = 620L;
    private final String identifier;
    private Object credentials;

    public CasServiceTicketAuthenticationToken(String identifier, Object credentials) {
        super(null);
        this.identifier = identifier;
        this.credentials = credentials;
        this.setAuthenticated(false);
    }

    public CasServiceTicketAuthenticationToken(String identifier, Object credentials, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.identifier = identifier;
        this.credentials = credentials;
        super.setAuthenticated(true);
    }

    public static CasServiceTicketAuthenticationToken stateful(Object credentials) {
        return new CasServiceTicketAuthenticationToken(CAS_STATEFUL_IDENTIFIER, credentials);
    }

    public static CasServiceTicketAuthenticationToken stateless(Object credentials) {
        return new CasServiceTicketAuthenticationToken(CAS_STATELESS_IDENTIFIER, credentials);
    }

    public boolean isStateless() {
        return CAS_STATELESS_IDENTIFIER.equals(this.identifier);
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.identifier;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        Assert.isTrue((!isAuthenticated ? 1 : 0) != 0, (String)"Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        super.setAuthenticated(false);
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.credentials = null;
    }
}

