/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.client;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.client.SMTPException;
import org.subethamail.smtp.io.DotTerminatedOutputStream;
import org.subethamail.smtp.io.ExtraDotOutputStream;

public class SMTPClient {
    private static final int CONNECT_TIMEOUT = 300000;
    private static final int REPLY_TIMEOUT = 600000;
    private static Logger log = LoggerFactory.getLogger(SMTPClient.class);
    private SocketAddress bindpoint;
    String hostPort;
    Socket socket;
    BufferedReader reader;
    OutputStream rawOutput;
    DotTerminatedOutputStream dotTerminatedOutput;
    ExtraDotOutputStream dataOutput;
    PrintWriter writer;

    public SMTPClient() {
    }

    public SMTPClient(String host, int port) throws UnknownHostException, IOException {
        this(host, port, null);
    }

    public SMTPClient(String host, int port, SocketAddress bindpoint) throws UnknownHostException, IOException {
        this.bindpoint = bindpoint;
        this.connect(host, port);
    }

    public void connect(String host, int port) throws IOException {
        if (this.socket != null) {
            throw new IllegalStateException("Already connected");
        }
        this.hostPort = String.valueOf(host) + ":" + port;
        if (log.isDebugEnabled()) {
            log.debug("Connecting to " + this.hostPort);
        }
        this.socket = this.createSocket();
        this.socket.bind(this.bindpoint);
        this.socket.setSoTimeout(600000);
        this.socket.connect(new InetSocketAddress(host, port), 300000);
        try {
            this.bindpoint = this.socket.getLocalSocketAddress();
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.rawOutput = this.socket.getOutputStream();
            this.dotTerminatedOutput = new DotTerminatedOutputStream(this.rawOutput);
            this.dataOutput = new ExtraDotOutputStream(this.dotTerminatedOutput);
            this.writer = new PrintWriter(this.rawOutput, true);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    protected Socket createSocket() {
        return new Socket();
    }

    public String getHostPort() {
        return this.hostPort;
    }

    protected void send(String msg) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Client: " + msg);
        }
        this.writer.print(String.valueOf(msg) + "\r\n");
        this.writer.flush();
    }

    protected Response receive() throws IOException {
        int code;
        StringBuilder builder = new StringBuilder();
        String line = null;
        boolean done = false;
        do {
            if ((line = this.reader.readLine()) == null) {
                if (builder.length() == 0) {
                    throw new EOFException("Server disconnected unexpectedly, no reply received");
                }
                throw new IOException("Malformed SMTP reply: " + builder);
            }
            if (log.isDebugEnabled()) {
                log.debug("Server: " + line);
            }
            if (line.length() < 4) {
                throw new IOException("Malformed SMTP reply: " + line);
            }
            builder.append(line.substring(4));
            if (line.charAt(3) == '-') {
                builder.append('\n');
                continue;
            }
            done = true;
        } while (!done);
        String codeString = line.substring(0, 3);
        try {
            code = Integer.parseInt(codeString);
        }
        catch (NumberFormatException e) {
            throw new IOException("Malformed SMTP reply: " + line, e);
        }
        return new Response(code, builder.toString());
    }

    public Response sendReceive(String msg) throws IOException {
        this.send(msg);
        return this.receive();
    }

    public void receiveAndCheck() throws IOException, SMTPException {
        Response resp = this.receive();
        if (!resp.isSuccess()) {
            throw new SMTPException(resp);
        }
    }

    public void sendAndCheck(String msg) throws IOException, SMTPException {
        this.send(msg);
        this.receiveAndCheck();
    }

    public void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
                if (log.isDebugEnabled()) {
                    log.debug("Closed connection to " + this.hostPort);
                }
            }
            catch (IOException ex) {
                log.error("Problem closing connection to " + this.hostPort, (Throwable)ex);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " { " + this.hostPort + "}";
    }

    public void setBindpoint(SocketAddress bindpoint) {
        this.bindpoint = bindpoint;
    }

    public SocketAddress getBindpoint() {
        return this.bindpoint;
    }

    public static class Response {
        int code;
        String message;

        public Response(int code, String text) {
            this.code = code;
            this.message = text;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return this.code >= 100 && this.code < 400;
        }

        public String toString() {
            return String.valueOf(this.code) + " " + this.message;
        }
    }
}

