/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.emberjs;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Vector;
import ro.isdc.wro.extensions.locator.WebjarUriLocator;
import ro.isdc.wro.extensions.processor.support.template.AbstractJsTemplateCompiler;

public class EmberJs
extends AbstractJsTemplateCompiler {
    private static final String DEFAULT_HEADLESS_RHINO_JS = "headless-rhino.js";
    private WebjarUriLocator webjarLocator;

    @Override
    public String compile(String content, String name) {
        String precompiledFunction = super.compile(content, "");
        return String.format("(function() {Ember.TEMPLATES[%s] = Ember.Handlebars.template(%s)})();", name, precompiledFunction);
    }

    @Override
    protected String getCompileCommand() {
        return "precompile";
    }

    @Override
    protected InputStream getCompilerAsStream() throws IOException {
        Vector<InputStream> inputStreams = new Vector<InputStream>();
        inputStreams.add(this.getWebjarLocator().locate(WebjarUriLocator.createUri("jquery.js")));
        inputStreams.add(this.getWebjarLocator().locate(WebjarUriLocator.createUri("handlebars.js")));
        inputStreams.add(this.getWebjarLocator().locate(WebjarUriLocator.createUri("ember.js")));
        inputStreams.add(EmberJs.class.getResourceAsStream(DEFAULT_HEADLESS_RHINO_JS));
        return new SequenceInputStream(inputStreams.elements());
    }

    private WebjarUriLocator getWebjarLocator() {
        if (this.webjarLocator == null) {
            this.webjarLocator = new WebjarUriLocator();
        }
        return this.webjarLocator;
    }
}

