/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.support.lint;

import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Document;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.support.lint.LintReport;

public abstract class AbstractReportXmlFormatter<T> {
    private Document doc;
    private LintReport<T> lintReport;

    protected AbstractReportXmlFormatter(LintReport<T> lintReport) {
        Validate.notNull(lintReport);
        this.lintReport = lintReport;
        this.initDocument();
    }

    private void initDocument() {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new WroRuntimeException("Unexpected problem while XML Document", (Throwable)e);
        }
    }

    public final void write(OutputStream outputStream) {
        this.buildDocument();
        this.writeReport(outputStream);
    }

    protected abstract void buildDocument();

    protected final LintReport<T> getLintReport() {
        return this.lintReport;
    }

    protected final Document getDocument() {
        return this.doc;
    }

    private void writeReport(OutputStream outputStream) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(this.doc), new StreamResult(outputStream));
        }
        catch (Exception e) {
            throw WroRuntimeException.wrap((Exception)e, (String)"Problem during Document transformation").logError();
        }
    }
}

