/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PemUtils {
    private static final int ALLOWED_CHARS_PER_LINE = 64;
    private static final String BASE_64_ENCODING_CHARS = "a-zA-Z0-9=+\\/";
    private static final String ALLOWED_WHITESPACE_CHARS = " \\r\\n";
    private static final String DELIMITER_CHARS = "-";
    private static final String MINUMUM_ALLOWED_PEM_CHARACTER_SET = "a-zA-Z0-9=+\\/ \\r\\n-";
    private static final String NON_BASE64_CHARACTER_SET = "[^a-zA-Z0-9=+\\/]+";
    private static final String UNNECESSARY_PEM_CHARACTER_SET = "[^a-zA-Z0-9=+\\/ \\r\\n-]+";
    private static final String PEM_OBJECT_TYPE = "([A-Z0-9 ]+)";
    private static final String PEM_DASHES = "[-]+";
    private static final String PEM_NON_DASHES = "([^-]+)";
    private static final String PEM_BEGIN_LINE_REGEX = "[-]+BEGIN ([A-Z0-9 ]+)[-]+";
    private static final String PEM_CONTENTS_REGEX = "([^-]+)";
    private static final String PEM_END_LINE_REGEX = "[-]+END ([A-Z0-9 ]+)[-]+";
    private static final Pattern INVALID_PEM_CHARACTER_PATTERN = Pattern.compile("[^a-zA-Z0-9=+\\/ \\r\\n-]+");
    private static final Pattern PEM_BEGIN_PATTERN = Pattern.compile("[-]+BEGIN ([A-Z0-9 ]+)[-]+");
    private static final Pattern PEM_END_PATTERN = Pattern.compile("[-]+END ([A-Z0-9 ]+)[-]+");
    private static final Pattern PEM_OBJECT_PATTERN = Pattern.compile("[-]+BEGIN ([A-Z0-9 ]+)[-]+([^-]+)[-]+END ([A-Z0-9 ]+)[-]+");
    private static final Pattern COMBINED_PEM_HEADERS = Pattern.compile("[-]+END ([A-Z0-9 ]+)[-]+BEGIN");

    private PemUtils() {
    }

    public static String removeInvalidPemChars(String pem) {
        if (pem == null || pem.length() == 0) {
            return pem;
        }
        return pem.replaceAll(UNNECESSARY_PEM_CHARACTER_SET, "");
    }

    private static String removeNonBase64Chars(String base64Contents) {
        if (base64Contents == null || base64Contents.length() == 0) {
            return base64Contents;
        }
        return base64Contents.replaceAll(NON_BASE64_CHARACTER_SET, "");
    }

    private static String formatAccordingToRFC(String pem) {
        if (pem == null || pem.length() == 0) {
            return pem;
        }
        Matcher matcher = PEM_OBJECT_PATTERN.matcher(pem);
        StringBuffer outBuffer = new StringBuffer();
        int count = 0;
        while (matcher.find()) {
            if (count > 0) {
                outBuffer.append('\n');
            }
            String beginType = matcher.group(1);
            String base64Contents = PemUtils.removeNonBase64Chars(matcher.group(2));
            String endType = matcher.group(3);
            outBuffer.append("-----BEGIN " + beginType + "-----\n");
            int index = 0;
            for (char c : base64Contents.toCharArray()) {
                outBuffer.append(c);
                if (++index % 64 != 0) continue;
                outBuffer.append('\n');
            }
            if (outBuffer.charAt(outBuffer.length() - 1) != '\n') {
                outBuffer.append('\n');
            }
            outBuffer.append("-----END " + endType + "-----");
            ++count;
        }
        return outBuffer.toString();
    }

    private static String splitCombinedPemHeaders(String pem) {
        if (pem == null || pem.length() == 0) {
            return pem;
        }
        Matcher m = COMBINED_PEM_HEADERS.matcher(pem);
        if (m.find()) {
            return m.replaceAll("-----END $1-----\n-----BEGIN");
        }
        return pem;
    }

    private static String mergeSpaces(String pem) {
        if (pem == null || pem.length() == 0) {
            return pem;
        }
        return pem.replaceAll("[ ]+", " ");
    }

    private static String removeSpacesNextToDashes(String pem) {
        if (pem == null || pem.length() == 0) {
            return pem;
        }
        return pem.replaceAll("( -)|(- )", DELIMITER_CHARS);
    }

    public static String cleanUpPem(String pem) {
        if (pem == null || pem.length() == 0) {
            return pem;
        }
        String cleanPem = PemUtils.removeInvalidPemChars(pem);
        cleanPem = PemUtils.mergeSpaces(cleanPem);
        cleanPem = PemUtils.removeSpacesNextToDashes(cleanPem);
        cleanPem = PemUtils.splitCombinedPemHeaders(cleanPem);
        cleanPem = PemUtils.formatAccordingToRFC(cleanPem);
        return cleanPem;
    }

    private static void validateCharacterSet(String pem) {
        if (INVALID_PEM_CHARACTER_PATTERN.matcher(pem).matches()) {
            StringBuilder debugStr = new StringBuilder();
            int index = 0;
            for (char c : pem.toCharArray()) {
                if (INVALID_PEM_CHARACTER_PATTERN.matcher(String.valueOf(c)).matches()) {
                    if (debugStr.length() > 0) {
                        debugStr.append(", ");
                    }
                    debugStr.append("\\u" + c + " at index " + index);
                }
                ++index;
            }
            throw new IllegalArgumentException("Illegal Characters found in PEM file. Chars: " + debugStr);
        }
    }

    private static int validatePemByRegexParser(String pem, String expectedPemTypeSubString, int maxChainDepth) {
        int beginCount = 0;
        int endCount = 0;
        int objCount = 0;
        Matcher beginMatcher = PEM_BEGIN_PATTERN.matcher(pem);
        Matcher endMatcher = PEM_END_PATTERN.matcher(pem);
        Matcher objMatcher = PEM_OBJECT_PATTERN.matcher(pem);
        while (beginMatcher.find()) {
            ++beginCount;
        }
        while (endMatcher.find()) {
            ++endCount;
        }
        while (objMatcher.find()) {
            String beginType = objMatcher.group(1);
            String base64Contents = objMatcher.group(2);
            String endType = objMatcher.group(3);
            if (!beginType.contains(expectedPemTypeSubString) || !endType.contains(expectedPemTypeSubString)) {
                throw new IllegalArgumentException("PEM Object does not have expected type. Expected Type: " + expectedPemTypeSubString + ", Actual BEGIN Type: " + beginType + ", Actual END Type: " + endType);
            }
            if (base64Contents.length() == 0) {
                throw new IllegalArgumentException("PEM Objet does not have any contents");
            }
            ++objCount;
        }
        if (objCount == 0) {
            throw new IllegalArgumentException("PEM contains no objects, or is not a PEM");
        }
        if (beginCount != endCount || beginCount != objCount) {
            throw new IllegalArgumentException("PEM has mismatching BEGIN and END Delimiters. BeginCount: " + beginCount + ", EndCount: " + endCount + ", ObjCount: " + objCount);
        }
        if (beginCount > maxChainDepth) {
            throw new IllegalArgumentException("PEM has greater than expected depth, ExpectedMax: " + maxChainDepth + ", Actual: " + beginCount);
        }
        return beginCount;
    }

    public static void sanityCheck(String pem, int maxChainLength, String expectedPemTypeSubString) {
        if (pem == null || pem.length() == 0) {
            return;
        }
        PemUtils.validateCharacterSet(pem);
        PemUtils.validatePemByRegexParser(pem, expectedPemTypeSubString, maxChainLength);
    }

    public static boolean safeSanityCheck(String pem, int maxChainLength, String expectedPemTypeSubString) {
        try {
            PemUtils.sanityCheck(pem, maxChainLength, expectedPemTypeSubString);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }
}

