/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRecommenderConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateRecommenderConfiguration> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateRecommenderConfiguration.getter(CreateRecommenderConfiguration::attributes)).setter(CreateRecommenderConfiguration.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRecommenderConfiguration.getter(CreateRecommenderConfiguration::description)).setter(CreateRecommenderConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRecommenderConfiguration.getter(CreateRecommenderConfiguration::name)).setter(CreateRecommenderConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RECOMMENDATION_PROVIDER_ID_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRecommenderConfiguration.getter(CreateRecommenderConfiguration::recommendationProviderIdType)).setter(CreateRecommenderConfiguration.setter(Builder::recommendationProviderIdType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderIdType").build()}).build();
    private static final SdkField<String> RECOMMENDATION_PROVIDER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRecommenderConfiguration.getter(CreateRecommenderConfiguration::recommendationProviderRoleArn)).setter(CreateRecommenderConfiguration.setter(Builder::recommendationProviderRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderRoleArn").build()}).build();
    private static final SdkField<String> RECOMMENDATION_PROVIDER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRecommenderConfiguration.getter(CreateRecommenderConfiguration::recommendationProviderUri)).setter(CreateRecommenderConfiguration.setter(Builder::recommendationProviderUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationProviderUri").build()}).build();
    private static final SdkField<String> RECOMMENDATION_TRANSFORMER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRecommenderConfiguration.getter(CreateRecommenderConfiguration::recommendationTransformerUri)).setter(CreateRecommenderConfiguration.setter(Builder::recommendationTransformerUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationTransformerUri").build()}).build();
    private static final SdkField<String> RECOMMENDATIONS_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRecommenderConfiguration.getter(CreateRecommenderConfiguration::recommendationsDisplayName)).setter(CreateRecommenderConfiguration.setter(Builder::recommendationsDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationsDisplayName").build()}).build();
    private static final SdkField<Integer> RECOMMENDATIONS_PER_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateRecommenderConfiguration.getter(CreateRecommenderConfiguration::recommendationsPerMessage)).setter(CreateRecommenderConfiguration.setter(Builder::recommendationsPerMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationsPerMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, DESCRIPTION_FIELD, NAME_FIELD, RECOMMENDATION_PROVIDER_ID_TYPE_FIELD, RECOMMENDATION_PROVIDER_ROLE_ARN_FIELD, RECOMMENDATION_PROVIDER_URI_FIELD, RECOMMENDATION_TRANSFORMER_URI_FIELD, RECOMMENDATIONS_DISPLAY_NAME_FIELD, RECOMMENDATIONS_PER_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> attributes;
    private final String description;
    private final String name;
    private final String recommendationProviderIdType;
    private final String recommendationProviderRoleArn;
    private final String recommendationProviderUri;
    private final String recommendationTransformerUri;
    private final String recommendationsDisplayName;
    private final Integer recommendationsPerMessage;

    private CreateRecommenderConfiguration(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.description = builder.description;
        this.name = builder.name;
        this.recommendationProviderIdType = builder.recommendationProviderIdType;
        this.recommendationProviderRoleArn = builder.recommendationProviderRoleArn;
        this.recommendationProviderUri = builder.recommendationProviderUri;
        this.recommendationTransformerUri = builder.recommendationTransformerUri;
        this.recommendationsDisplayName = builder.recommendationsDisplayName;
        this.recommendationsPerMessage = builder.recommendationsPerMessage;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public String recommendationProviderIdType() {
        return this.recommendationProviderIdType;
    }

    public String recommendationProviderRoleArn() {
        return this.recommendationProviderRoleArn;
    }

    public String recommendationProviderUri() {
        return this.recommendationProviderUri;
    }

    public String recommendationTransformerUri() {
        return this.recommendationTransformerUri;
    }

    public String recommendationsDisplayName() {
        return this.recommendationsDisplayName;
    }

    public Integer recommendationsPerMessage() {
        return this.recommendationsPerMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationProviderIdType());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationProviderRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationProviderUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationTransformerUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationsDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationsPerMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecommenderConfiguration)) {
            return false;
        }
        CreateRecommenderConfiguration other = (CreateRecommenderConfiguration)obj;
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recommendationProviderIdType(), other.recommendationProviderIdType()) && Objects.equals(this.recommendationProviderRoleArn(), other.recommendationProviderRoleArn()) && Objects.equals(this.recommendationProviderUri(), other.recommendationProviderUri()) && Objects.equals(this.recommendationTransformerUri(), other.recommendationTransformerUri()) && Objects.equals(this.recommendationsDisplayName(), other.recommendationsDisplayName()) && Objects.equals(this.recommendationsPerMessage(), other.recommendationsPerMessage());
    }

    public String toString() {
        return ToString.builder((String)"CreateRecommenderConfiguration").add("Attributes", this.attributes()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("RecommendationProviderIdType", (Object)this.recommendationProviderIdType()).add("RecommendationProviderRoleArn", (Object)this.recommendationProviderRoleArn()).add("RecommendationProviderUri", (Object)this.recommendationProviderUri()).add("RecommendationTransformerUri", (Object)this.recommendationTransformerUri()).add("RecommendationsDisplayName", (Object)this.recommendationsDisplayName()).add("RecommendationsPerMessage", (Object)this.recommendationsPerMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RecommendationProviderIdType": {
                return Optional.ofNullable(clazz.cast(this.recommendationProviderIdType()));
            }
            case "RecommendationProviderRoleArn": {
                return Optional.ofNullable(clazz.cast(this.recommendationProviderRoleArn()));
            }
            case "RecommendationProviderUri": {
                return Optional.ofNullable(clazz.cast(this.recommendationProviderUri()));
            }
            case "RecommendationTransformerUri": {
                return Optional.ofNullable(clazz.cast(this.recommendationTransformerUri()));
            }
            case "RecommendationsDisplayName": {
                return Optional.ofNullable(clazz.cast(this.recommendationsDisplayName()));
            }
            case "RecommendationsPerMessage": {
                return Optional.ofNullable(clazz.cast(this.recommendationsPerMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRecommenderConfiguration, T> g) {
        return obj -> g.apply((CreateRecommenderConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String description;
        private String name;
        private String recommendationProviderIdType;
        private String recommendationProviderRoleArn;
        private String recommendationProviderUri;
        private String recommendationTransformerUri;
        private String recommendationsDisplayName;
        private Integer recommendationsPerMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecommenderConfiguration model) {
            this.attributes(model.attributes);
            this.description(model.description);
            this.name(model.name);
            this.recommendationProviderIdType(model.recommendationProviderIdType);
            this.recommendationProviderRoleArn(model.recommendationProviderRoleArn);
            this.recommendationProviderUri(model.recommendationProviderUri);
            this.recommendationTransformerUri(model.recommendationTransformerUri);
            this.recommendationsDisplayName(model.recommendationsDisplayName);
            this.recommendationsPerMessage(model.recommendationsPerMessage);
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRecommendationProviderIdType() {
            return this.recommendationProviderIdType;
        }

        @Override
        public final Builder recommendationProviderIdType(String recommendationProviderIdType) {
            this.recommendationProviderIdType = recommendationProviderIdType;
            return this;
        }

        public final void setRecommendationProviderIdType(String recommendationProviderIdType) {
            this.recommendationProviderIdType = recommendationProviderIdType;
        }

        public final String getRecommendationProviderRoleArn() {
            return this.recommendationProviderRoleArn;
        }

        @Override
        public final Builder recommendationProviderRoleArn(String recommendationProviderRoleArn) {
            this.recommendationProviderRoleArn = recommendationProviderRoleArn;
            return this;
        }

        public final void setRecommendationProviderRoleArn(String recommendationProviderRoleArn) {
            this.recommendationProviderRoleArn = recommendationProviderRoleArn;
        }

        public final String getRecommendationProviderUri() {
            return this.recommendationProviderUri;
        }

        @Override
        public final Builder recommendationProviderUri(String recommendationProviderUri) {
            this.recommendationProviderUri = recommendationProviderUri;
            return this;
        }

        public final void setRecommendationProviderUri(String recommendationProviderUri) {
            this.recommendationProviderUri = recommendationProviderUri;
        }

        public final String getRecommendationTransformerUri() {
            return this.recommendationTransformerUri;
        }

        @Override
        public final Builder recommendationTransformerUri(String recommendationTransformerUri) {
            this.recommendationTransformerUri = recommendationTransformerUri;
            return this;
        }

        public final void setRecommendationTransformerUri(String recommendationTransformerUri) {
            this.recommendationTransformerUri = recommendationTransformerUri;
        }

        public final String getRecommendationsDisplayName() {
            return this.recommendationsDisplayName;
        }

        @Override
        public final Builder recommendationsDisplayName(String recommendationsDisplayName) {
            this.recommendationsDisplayName = recommendationsDisplayName;
            return this;
        }

        public final void setRecommendationsDisplayName(String recommendationsDisplayName) {
            this.recommendationsDisplayName = recommendationsDisplayName;
        }

        public final Integer getRecommendationsPerMessage() {
            return this.recommendationsPerMessage;
        }

        @Override
        public final Builder recommendationsPerMessage(Integer recommendationsPerMessage) {
            this.recommendationsPerMessage = recommendationsPerMessage;
            return this;
        }

        public final void setRecommendationsPerMessage(Integer recommendationsPerMessage) {
            this.recommendationsPerMessage = recommendationsPerMessage;
        }

        public CreateRecommenderConfiguration build() {
            return new CreateRecommenderConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateRecommenderConfiguration> {
        public Builder attributes(Map<String, String> var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder recommendationProviderIdType(String var1);

        public Builder recommendationProviderRoleArn(String var1);

        public Builder recommendationProviderUri(String var1);

        public Builder recommendationTransformerUri(String var1);

        public Builder recommendationsDisplayName(String var1);

        public Builder recommendationsPerMessage(Integer var1);
    }
}

