/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum BucketLocationConstraint {
    EU("EU"),

    EU_WEST_1("eu-west-1"),

    US_WEST_1("us-west-1"),

    US_WEST_2("us-west-2"),

    AP_SOUTH_1("ap-south-1"),

    AP_SOUTHEAST_1("ap-southeast-1"),

    AP_SOUTHEAST_2("ap-southeast-2"),

    AP_NORTHEAST_1("ap-northeast-1"),

    SA_EAST_1("sa-east-1"),

    CN_NORTH_1("cn-north-1"),

    EU_CENTRAL_1("eu-central-1"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BucketLocationConstraint(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return BucketLocationConstraint corresponding to the value
     */
    public static BucketLocationConstraint fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BucketLocationConstraint.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link BucketLocationConstraint}s
     */
    public static Set<BucketLocationConstraint> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
