/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.endpoints;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.internal.endpoints.S3AccessPointEndpointResolver;
import software.amazon.awssdk.services.s3.internal.endpoints.S3BucketEndpointResolver;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointResolver;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointUtils;

@SdkInternalApi
public final class S3EndpointResolverFactory {
    private static final S3EndpointResolver ACCESS_POINT_ENDPOINT_RESOLVER = S3AccessPointEndpointResolver.create();
    private static final S3EndpointResolver BUCKET_ENDPOINT_RESOLVER = S3BucketEndpointResolver.create();

    private S3EndpointResolverFactory() {
    }

    public static S3EndpointResolver getEndpointResolver(String bucketName) {
        if (bucketName != null && S3EndpointUtils.isArn(bucketName)) {
            return ACCESS_POINT_ENDPOINT_RESOLVER;
        }
        return BUCKET_ENDPOINT_RESOLVER;
    }
}

