/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.signing;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.core.internal.util.ClassLoaderHelper;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.s3.internal.endpoints.S3EndpointUtils;
import software.amazon.awssdk.services.s3.internal.resource.S3ArnConverter;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.Lazy;

@SdkInternalApi
public final class S3SigningUtils {
    private static final String SIGV4A_SIGNER_CLASS = "software.amazon.awssdk.authcrt.signer.AwsCrtS3V4aSigner";
    private static final Lazy<Signer> SIGV4A_SIGNER = new Lazy(S3SigningUtils::initializeV4aSigner);

    private S3SigningUtils() {
    }

    public static Signer getSigV4aSigner() {
        return (Signer)SIGV4A_SIGNER.getValue();
    }

    public static Optional<Signer> internalSignerOverride(S3Request originalRequest) {
        return originalRequest.getValueForField("Bucket", String.class).filter(S3EndpointUtils::isArn).flatMap(S3SigningUtils::getS3ResourceSigner);
    }

    private static Optional<Signer> getS3ResourceSigner(String name) {
        S3Resource resolvedS3Resource = S3ArnConverter.create().convertArn(Arn.fromString((String)name));
        return resolvedS3Resource.overrideSigner();
    }

    private static Signer initializeV4aSigner() {
        try {
            Class signerClass = ClassLoaderHelper.loadClass((String)SIGV4A_SIGNER_CLASS, (boolean)false, (Class[])new Class[]{null});
            Method m = signerClass.getDeclaredMethod("create", new Class[0]);
            Object o = m.invoke(null, new Object[0]);
            return (Signer)o;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot find the software.amazon.awssdk.authcrt.signer.AwsCrtS3V4aSigner class. To invoke a request that requires a SigV4a signer, such as region independent signing, the 'auth-crt' core module must be on the class path. ", e);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to create an S3 SigV4a signer.", e);
        }
    }
}

