/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.listener.PublisherListener;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.multipart.GenericMultipartHelper;
import software.amazon.awssdk.services.s3.internal.multipart.SdkPojoConversionUtils;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public final class MultipartUploadHelper {
    private static final Logger log = Logger.loggerFor(MultipartUploadHelper.class);
    private final S3AsyncClient s3AsyncClient;
    private final GenericMultipartHelper<PutObjectRequest, PutObjectResponse> genericMultipartHelper;
    private final long maxMemoryUsageInBytes;
    private final long multipartUploadThresholdInBytes;

    public MultipartUploadHelper(S3AsyncClient s3AsyncClient, long multipartUploadThresholdInBytes, long maxMemoryUsageInBytes) {
        this.s3AsyncClient = s3AsyncClient;
        this.genericMultipartHelper = new GenericMultipartHelper<PutObjectRequest, PutObjectResponse>(s3AsyncClient, SdkPojoConversionUtils::toAbortMultipartUploadRequest, SdkPojoConversionUtils::toPutObjectResponse);
        this.maxMemoryUsageInBytes = maxMemoryUsageInBytes;
        this.multipartUploadThresholdInBytes = multipartUploadThresholdInBytes;
    }

    CompletableFuture<CreateMultipartUploadResponse> createMultipartUpload(PutObjectRequest putObjectRequest, CompletableFuture<PutObjectResponse> returnFuture) {
        CreateMultipartUploadRequest request = SdkPojoConversionUtils.toCreateMultipartUploadRequest(putObjectRequest);
        CompletableFuture<CreateMultipartUploadResponse> createMultipartUploadFuture = this.s3AsyncClient.createMultipartUpload(request);
        CompletableFutureUtils.forwardExceptionTo(returnFuture, createMultipartUploadFuture);
        return createMultipartUploadFuture;
    }

    CompletableFuture<CompleteMultipartUploadResponse> completeMultipartUpload(CompletableFuture<PutObjectResponse> returnFuture, String uploadId, CompletedPart[] completedParts, PutObjectRequest putObjectRequest, long contentLength) {
        CompletableFuture<CompleteMultipartUploadResponse> future = this.genericMultipartHelper.completeMultipartUpload(putObjectRequest, uploadId, completedParts, contentLength);
        ((CompletableFuture)future.handle(this.genericMultipartHelper.handleExceptionOrResponse(putObjectRequest, returnFuture, uploadId))).exceptionally(throwable -> {
            this.genericMultipartHelper.handleException(returnFuture, () -> "Unexpected exception occurred", (Throwable)throwable);
            return null;
        });
        return future;
    }

    CompletableFuture<CompletedPart> sendIndividualUploadPartRequest(String uploadId, Consumer<CompletedPart> completedPartsConsumer, Collection<CompletableFuture<CompletedPart>> futures, Pair<UploadPartRequest, AsyncRequestBody> requestPair, PublisherListener<Long> progressListener) {
        UploadPartRequest uploadPartRequest = (UploadPartRequest)((Object)requestPair.left());
        Integer partNumber = uploadPartRequest.partNumber();
        Optional contentLength = ((AsyncRequestBody)requestPair.right()).contentLength();
        log.debug(() -> "Sending uploadPartRequest: " + uploadPartRequest.partNumber() + " uploadId: " + uploadId + " contentLength " + contentLength);
        CompletableFuture<UploadPartResponse> uploadPartFuture = this.s3AsyncClient.uploadPart(uploadPartRequest, (AsyncRequestBody)requestPair.right());
        CompletionStage convertFuture = uploadPartFuture.thenApply(uploadPartResponse -> {
            contentLength.ifPresent(arg_0 -> ((PublisherListener)progressListener).subscriberOnNext(arg_0));
            return MultipartUploadHelper.convertUploadPartResponse(completedPartsConsumer, partNumber, uploadPartResponse);
        });
        futures.add((CompletableFuture<CompletedPart>)convertFuture);
        CompletableFutureUtils.forwardExceptionTo((CompletableFuture)convertFuture, uploadPartFuture);
        return convertFuture;
    }

    void failRequestsElegantly(Collection<CompletableFuture<CompletedPart>> futures, Throwable t, String uploadId, CompletableFuture<PutObjectResponse> returnFuture, PutObjectRequest putObjectRequest) {
        try {
            this.genericMultipartHelper.handleException(returnFuture, () -> "Failed to send multipart upload requests", t);
            if (uploadId != null) {
                this.genericMultipartHelper.cleanUpParts(uploadId, SdkPojoConversionUtils.toAbortMultipartUploadRequest(putObjectRequest));
            }
            MultipartUploadHelper.cancelingOtherOngoingRequests(futures, t);
        }
        catch (Throwable throwable) {
            returnFuture.completeExceptionally((Throwable)SdkClientException.create((String)"Unexpected error occurred while handling the upstream exception.", (Throwable)throwable));
        }
    }

    static void cancelingOtherOngoingRequests(Collection<CompletableFuture<CompletedPart>> futures, Throwable t) {
        log.trace(() -> "cancelling other ongoing requests " + futures.size());
        futures.forEach(f -> f.completeExceptionally(t));
    }

    static CompletedPart convertUploadPartResponse(Consumer<CompletedPart> consumer, Integer partNumber, UploadPartResponse uploadPartResponse) {
        CompletedPart completedPart = SdkPojoConversionUtils.toCompletedPart(uploadPartResponse, (int)partNumber);
        consumer.accept(completedPart);
        return completedPart;
    }

    void uploadInOneChunk(PutObjectRequest putObjectRequest, AsyncRequestBody asyncRequestBody, CompletableFuture<PutObjectResponse> returnFuture) {
        CompletableFuture<PutObjectResponse> putObjectResponseCompletableFuture = this.s3AsyncClient.putObject(putObjectRequest, asyncRequestBody);
        CompletableFutureUtils.forwardExceptionTo(returnFuture, putObjectResponseCompletableFuture);
        CompletableFutureUtils.forwardResultTo(putObjectResponseCompletableFuture, returnFuture);
    }

    static SdkClientException contentLengthMissingForPart(int currentPartNum) {
        return SdkClientException.create((String)("Content length is missing on the AsyncRequestBody for part number " + currentPartNum));
    }

    static SdkClientException contentLengthMismatchForPart(long expected, long actual, int partNum) {
        return SdkClientException.create((String)String.format("Content length must not be greater than part size. Expected: %d, Actual: %d, partNum: %d", expected, actual, partNum));
    }

    static SdkClientException partNumMismatch(int expectedNumParts, int actualNumParts) {
        return SdkClientException.create((String)String.format("The number of parts divided is not equal to the expected number of parts. Expected: %d, Actual: %d", expectedNumParts, actualNumParts));
    }
}

