/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3.model.BucketInfo;
import software.amazon.awssdk.services.s3.model.BucketLocationConstraint;
import software.amazon.awssdk.services.s3.model.LocationInfo;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.TagSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBucketConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateBucketConfiguration> {
    private static final SdkField<String> LOCATION_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationConstraint").getter(CreateBucketConfiguration.getter(CreateBucketConfiguration::locationConstraintAsString)).setter(CreateBucketConfiguration.setter(Builder::locationConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationConstraint").unmarshallLocationName("LocationConstraint").build()}).build();
    private static final SdkField<LocationInfo> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Location").getter(CreateBucketConfiguration.getter(CreateBucketConfiguration::location)).setter(CreateBucketConfiguration.setter(Builder::location)).constructor(LocationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final SdkField<BucketInfo> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bucket").getter(CreateBucketConfiguration.getter(CreateBucketConfiguration::bucket)).setter(CreateBucketConfiguration.setter(Builder::bucket)).constructor(BucketInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateBucketConfiguration.getter(CreateBucketConfiguration::tags)).setter(CreateBucketConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").unmarshallLocationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_CONSTRAINT_FIELD, LOCATION_FIELD, BUCKET_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBucketConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String locationConstraint;
    private final LocationInfo location;
    private final BucketInfo bucket;
    private final List<Tag> tags;

    private CreateBucketConfiguration(BuilderImpl builder) {
        this.locationConstraint = builder.locationConstraint;
        this.location = builder.location;
        this.bucket = builder.bucket;
        this.tags = builder.tags;
    }

    public final BucketLocationConstraint locationConstraint() {
        return BucketLocationConstraint.fromValue(this.locationConstraint);
    }

    public final String locationConstraintAsString() {
        return this.locationConstraint;
    }

    public final LocationInfo location() {
        return this.location;
    }

    public final BucketInfo bucket() {
        return this.bucket;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locationConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBucketConfiguration)) {
            return false;
        }
        CreateBucketConfiguration other = (CreateBucketConfiguration)obj;
        return Objects.equals(this.locationConstraintAsString(), other.locationConstraintAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.bucket(), other.bucket()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBucketConfiguration").add("LocationConstraint", (Object)this.locationConstraintAsString()).add("Location", (Object)this.location()).add("Bucket", (Object)this.bucket()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationConstraint": {
                return Optional.ofNullable(clazz.cast(this.locationConstraintAsString()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LocationConstraint", LOCATION_CONSTRAINT_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("Bucket", BUCKET_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBucketConfiguration, T> g) {
        return obj -> g.apply((CreateBucketConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String locationConstraint;
        private LocationInfo location;
        private BucketInfo bucket;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBucketConfiguration model) {
            this.locationConstraint(model.locationConstraint);
            this.location(model.location);
            this.bucket(model.bucket);
            this.tags(model.tags);
        }

        public final String getLocationConstraint() {
            return this.locationConstraint;
        }

        public final void setLocationConstraint(String locationConstraint) {
            this.locationConstraint = locationConstraint;
        }

        @Override
        public final Builder locationConstraint(String locationConstraint) {
            this.locationConstraint = locationConstraint;
            return this;
        }

        @Override
        public final Builder locationConstraint(BucketLocationConstraint locationConstraint) {
            this.locationConstraint(locationConstraint == null ? null : locationConstraint.toString());
            return this;
        }

        public final LocationInfo.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(LocationInfo.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(LocationInfo location) {
            this.location = location;
            return this;
        }

        public final BucketInfo.Builder getBucket() {
            return this.bucket != null ? this.bucket.toBuilder() : null;
        }

        public final void setBucket(BucketInfo.BuilderImpl bucket) {
            this.bucket = bucket != null ? bucket.build() : null;
        }

        @Override
        public final Builder bucket(BucketInfo bucket) {
            this.bucket = bucket;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagSetCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagSetCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagSetCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CreateBucketConfiguration build() {
            return new CreateBucketConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateBucketConfiguration> {
        public Builder locationConstraint(String var1);

        public Builder locationConstraint(BucketLocationConstraint var1);

        public Builder location(LocationInfo var1);

        default public Builder location(Consumer<LocationInfo.Builder> location) {
            return this.location((LocationInfo)((LocationInfo.Builder)LocationInfo.builder().applyMutation(location)).build());
        }

        public Builder bucket(BucketInfo var1);

        default public Builder bucket(Consumer<BucketInfo.Builder> bucket) {
            return this.bucket((BucketInfo)((BucketInfo.Builder)BucketInfo.builder().applyMutation(bucket)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

