/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.cache;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.ExecutorUtils;
import software.amazon.awssdk.utils.cache.CachedSupplier;

@SdkProtectedApi
public class NonBlocking
implements CachedSupplier.PrefetchStrategy {
    private final AtomicBoolean currentlyRefreshing = new AtomicBoolean(false);
    private final ExecutorService executor;

    public NonBlocking(String asyncThreadName) {
        this.executor = ExecutorUtils.newSingleDaemonThreadExecutor(1, asyncThreadName);
    }

    @Override
    public void prefetch(Runnable valueUpdater) {
        if (this.currentlyRefreshing.compareAndSet(false, true)) {
            try {
                this.executor.submit(() -> {
                    try {
                        valueUpdater.run();
                    }
                    finally {
                        this.currentlyRefreshing.set(false);
                    }
                });
            }
            catch (RuntimeException e) {
                this.currentlyRefreshing.set(false);
                throw e;
            }
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

