/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.IDMethod;
import org.apache.torque.engine.database.model.IdMethodParameter;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.Inheritance;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.Unique;
import org.xml.sax.Attributes;

public class Table
implements IDMethod {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$engine$database$model$Table == null ? (class$org$apache$torque$engine$database$model$Table = Table.class$("org.apache.torque.engine.database.model.Table")) : class$org$apache$torque$engine$database$model$Table));
    private List columnList;
    private List foreignKeys;
    private List indices;
    private List unices;
    private List idMethodParameters;
    private String name;
    private String description;
    private String javaName;
    private String idMethod;
    private String javaNamingMethod;
    private Database tableParent;
    private List referrers;
    private List foreignTableNames;
    private boolean containsForeignPK;
    private Column inheritanceColumn;
    private boolean skipSql;
    private boolean abstractValue;
    private String alias;
    private String enterface;
    private String pkg;
    private String baseClass;
    private String basePeer;
    private Hashtable columnsByName;
    private Hashtable columnsByJavaName;
    private boolean needsTransactionInPostgres;
    private boolean heavyIndexing;
    private boolean forReferenceOnly;
    static /* synthetic */ Class class$org$apache$torque$engine$database$model$Table;

    public Table() {
        this(null);
    }

    public Table(String name) {
        this.name = name;
        this.columnList = new ArrayList();
        this.foreignKeys = new ArrayList(5);
        this.indices = new ArrayList(5);
        this.unices = new ArrayList(5);
        this.columnsByName = new Hashtable();
        this.columnsByJavaName = new Hashtable();
    }

    public void loadFromXML(Attributes attrib, String defaultIdMethod) {
        this.name = attrib.getValue("name");
        this.javaName = attrib.getValue("javaName");
        this.idMethod = attrib.getValue("idMethod");
        this.javaNamingMethod = attrib.getValue("javaNamingMethod");
        if (this.javaNamingMethod == null) {
            this.javaNamingMethod = this.getDatabase().getDefaultJavaNamingMethod();
        }
        if ("null".equals(this.idMethod)) {
            this.idMethod = defaultIdMethod;
        }
        if ("autoincrement".equals(this.idMethod) || "sequence".equals(this.idMethod)) {
            log.warn((Object)("The value '" + this.idMethod + "' for Torque's " + "table.idMethod attribute has been deprecated in favor " + "of '" + "native" + "'.  Please adjust your " + "Torque XML schema accordingly."));
            this.idMethod = "native";
        }
        this.skipSql = "true".equals(attrib.getValue("skipSql"));
        this.abstractValue = "true".equals(attrib.getValue("abstract"));
        this.baseClass = attrib.getValue("baseClass");
        this.basePeer = attrib.getValue("basePeer");
        this.alias = attrib.getValue("alias");
        this.heavyIndexing = "true".equals(attrib.getValue("heavyIndexing")) || !"false".equals(attrib.getValue("heavyIndexing")) && this.getDatabase().isHeavyIndexing();
        this.description = attrib.getValue("description");
        this.enterface = attrib.getValue("interface");
    }

    public void doFinalInitialization() {
        if (this.heavyIndexing) {
            this.doHeavyIndexing();
        }
        this.doNaming();
    }

    private void doHeavyIndexing() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doHeavyIndex() called on table " + this.name));
        }
        List pk = this.getPrimaryKey();
        int size = pk.size();
        try {
            for (int i = 1; i < size; ++i) {
                this.addIndex(new Index(this, pk.subList(i, size)));
            }
        }
        catch (EngineException e) {
            log.error((Object)e, (Throwable)((Object)e));
        }
    }

    private void doNaming() {
        try {
            String name;
            int i;
            int size = this.foreignKeys.size();
            for (i = 0; i < size; ++i) {
                ForeignKey fk = (ForeignKey)this.foreignKeys.get(i);
                name = fk.getName();
                if (!StringUtils.isEmpty((String)name)) continue;
                name = this.acquireConstraintName("FK", i + 1);
                fk.setName(name);
            }
            size = this.indices.size();
            for (i = 0; i < size; ++i) {
                Index index = (Index)this.indices.get(i);
                name = index.getName();
                if (!StringUtils.isEmpty((String)name)) continue;
                name = this.acquireConstraintName("I", i + 1);
                index.setName(name);
            }
            size = this.unices.size();
            for (i = 0; i < size; ++i) {
                Unique unique = (Unique)this.unices.get(i);
                name = unique.getName();
                if (!StringUtils.isEmpty((String)name)) continue;
                name = this.acquireConstraintName("U", i + 1);
                unique.setName(name);
            }
        }
        catch (EngineException nameAlreadyInUse) {
            log.error((Object)nameAlreadyInUse, (Throwable)((Object)nameAlreadyInUse));
        }
    }

    private final String acquireConstraintName(String nameType, int nbr) throws EngineException {
        ArrayList<Object> inputs = new ArrayList<Object>(4);
        inputs.add(this.getDatabase());
        inputs.add(this.getName());
        inputs.add(nameType);
        inputs.add(new Integer(nbr));
        return NameFactory.generateName(NameFactory.CONSTRAINT_GENERATOR, inputs);
    }

    public String getBaseClass() {
        if (this.isAlias() && this.baseClass == null) {
            return this.alias;
        }
        if (this.baseClass == null) {
            return this.getDatabase().getBaseClass();
        }
        return this.baseClass;
    }

    public void setBaseClass(String v) {
        this.baseClass = v;
    }

    public String getBasePeer() {
        if (this.isAlias() && this.basePeer == null) {
            return this.alias + "Peer";
        }
        if (this.basePeer == null) {
            return this.getDatabase().getBasePeer();
        }
        return this.basePeer;
    }

    public void setBasePeer(String v) {
        this.basePeer = v;
    }

    public Column addColumn(Attributes attrib) {
        Column col = new Column();
        col.setTable(this);
        col.loadFromXML(attrib);
        this.addColumn(col);
        return col;
    }

    public void addColumn(Column col) {
        col.setTable(this);
        if (col.isInheritance()) {
            this.inheritanceColumn = col;
        }
        this.columnList.add(col);
        this.columnsByName.put(col.getName(), col);
        this.columnsByJavaName.put(col.getJavaName(), col);
        col.setPosition(this.columnList.size());
        this.needsTransactionInPostgres |= col.requiresTransactionInPostgres();
    }

    public ForeignKey addForeignKey(Attributes attrib) {
        ForeignKey fk = new ForeignKey();
        fk.loadFromXML(attrib);
        this.addForeignKey(fk);
        return fk;
    }

    public Column getChildrenColumn() {
        return this.inheritanceColumn;
    }

    public List getChildrenNames() {
        if (this.inheritanceColumn == null || !this.inheritanceColumn.isEnumeratedClasses()) {
            return null;
        }
        List children = this.inheritanceColumn.getChildren();
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (int i = 0; i < children.size(); ++i) {
            names.add(((Inheritance)children.get(i)).getClassName());
        }
        return names;
    }

    public void addReferrer(ForeignKey fk) {
        if (this.referrers == null) {
            this.referrers = new ArrayList(5);
        }
        this.referrers.add(fk);
    }

    public List getReferrers() {
        return this.referrers;
    }

    public void setContainsForeignPK(boolean b) {
        this.containsForeignPK = b;
    }

    public boolean getContainsForeignPK() {
        return this.containsForeignPK;
    }

    public List getForeignTableNames() {
        if (this.foreignTableNames == null) {
            this.foreignTableNames = new ArrayList(1);
        }
        return this.foreignTableNames;
    }

    public void addForeignKey(ForeignKey fk) {
        fk.setTable(this);
        this.foreignKeys.add(fk);
        if (this.foreignTableNames == null) {
            this.foreignTableNames = new ArrayList(5);
        }
        if (!this.foreignTableNames.contains(fk.getForeignTableName())) {
            this.foreignTableNames.add(fk.getForeignTableName());
        }
    }

    public boolean requiresTransactionInPostgres() {
        return this.needsTransactionInPostgres;
    }

    public IdMethodParameter addIdMethodParameter(Attributes attrib) {
        IdMethodParameter imp = new IdMethodParameter();
        imp.loadFromXML(attrib);
        this.addIdMethodParameter(imp);
        return imp;
    }

    public void addIdMethodParameter(IdMethodParameter imp) {
        imp.setTable(this);
        if (this.idMethodParameters == null) {
            this.idMethodParameters = new ArrayList(2);
        }
        this.idMethodParameters.add(imp);
    }

    public void addIndex(Index index) {
        index.setTable(this);
        this.indices.add(index);
    }

    public Index addIndex(Attributes attrib) {
        Index index = new Index();
        index.loadFromXML(attrib);
        this.addIndex(index);
        return index;
    }

    public void addUnique(Unique unique) {
        unique.setTable(this);
        this.unices.add(unique);
    }

    public Unique addUnique(Attributes attrib) {
        Unique unique = new Unique();
        unique.loadFromXML(attrib);
        this.addUnique(unique);
        return unique;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public String getJavaName() {
        if (this.javaName == null) {
            ArrayList<String> inputs = new ArrayList<String>(2);
            inputs.add(this.name);
            inputs.add(this.javaNamingMethod);
            try {
                this.javaName = NameFactory.generateName(NameFactory.JAVA_GENERATOR, inputs);
            }
            catch (EngineException e) {
                log.error((Object)e, (Throwable)((Object)e));
            }
        }
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getIdMethod() {
        if (this.idMethod == null) {
            return "none";
        }
        return this.idMethod;
    }

    public void setIdMethod(String idMethod) {
        this.idMethod = idMethod;
    }

    public boolean isSkipSql() {
        return this.skipSql || this.isAlias() || this.isForReferenceOnly();
    }

    public void setSkipSql(boolean v) {
        this.skipSql = v;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isAlias() {
        return this.alias != null;
    }

    public void setAlias(String v) {
        this.alias = v;
    }

    public String getInterface() {
        return this.enterface;
    }

    public void setInterface(String v) {
        this.enterface = v;
    }

    public boolean isAbstract() {
        return this.abstractValue;
    }

    public void setAbstract(boolean v) {
        this.abstractValue = v;
    }

    public String getPackage() {
        if (this.pkg != null) {
            return this.pkg;
        }
        return this.getDatabase().getPackage();
    }

    public void setPackage(String v) {
        this.pkg = v;
    }

    public Column[] getColumns() {
        int size = this.columnList.size();
        Column[] tbls = new Column[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = (Column)this.columnList.get(i);
        }
        return tbls;
    }

    public int getNumColumns() {
        return this.columnList.size();
    }

    public ForeignKey[] getForeignKeys() {
        int size = this.foreignKeys.size();
        ForeignKey[] tbls = new ForeignKey[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = (ForeignKey)this.foreignKeys.get(i);
        }
        return tbls;
    }

    public List getIdMethodParameters() {
        return this.idMethodParameters;
    }

    public String getSequenceName() {
        String result = null;
        if (this.getIdMethod().equals("native")) {
            List idMethodParams = this.getIdMethodParameters();
            result = idMethodParams == null ? this.getName() + "_SEQ" : ((IdMethodParameter)idMethodParams.get(0)).getValue();
        }
        return result;
    }

    public Index[] getIndices() {
        int size = this.indices.size();
        Index[] tbls = new Index[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = (Index)this.indices.get(i);
        }
        return tbls;
    }

    public Unique[] getUnices() {
        int size = this.unices.size();
        Unique[] tbls = new Unique[size];
        for (int i = 0; i < size; ++i) {
            tbls[i] = (Unique)this.unices.get(i);
        }
        return tbls;
    }

    public Column getColumn(String name) {
        return (Column)this.columnsByName.get(name);
    }

    public Column getColumnByJavaName(String javaName) {
        return (Column)this.columnsByJavaName.get(javaName);
    }

    public ForeignKey getForeignKey(String col) {
        ForeignKey firstFK = null;
        Iterator iter = this.foreignKeys.iterator();
        while (iter.hasNext()) {
            ForeignKey key = (ForeignKey)iter.next();
            if (!key.getLocalColumns().contains(col) || firstFK != null) continue;
            firstFK = key;
        }
        return firstFK;
    }

    public boolean containsColumn(Column col) {
        return this.columnList.contains(col);
    }

    public boolean containsColumn(String name) {
        return this.getColumn(name) != null;
    }

    public void setDatabase(Database parent) {
        this.tableParent = parent;
    }

    public Database getDatabase() {
        return this.tableParent;
    }

    public boolean isForReferenceOnly() {
        return this.forReferenceOnly;
    }

    public void setForReferenceOnly(boolean v) {
        this.forReferenceOnly = v;
    }

    public String toString() {
        Iterator iter;
        StringBuffer result = new StringBuffer();
        result.append("<table name=\"").append(this.name).append('\"');
        if (this.javaName != null) {
            result.append(" javaName=\"").append(this.javaName).append('\"');
        }
        if (this.idMethod != null) {
            result.append(" idMethod=\"").append(this.idMethod).append('\"');
        }
        if (this.skipSql) {
            result.append(" skipSql=\"").append(new Boolean(this.skipSql)).append('\"');
        }
        if (this.abstractValue) {
            result.append(" abstract=\"").append(new Boolean(this.abstractValue)).append('\"');
        }
        if (this.baseClass != null) {
            result.append(" baseClass=\"").append(this.baseClass).append('\"');
        }
        if (this.basePeer != null) {
            result.append(" basePeer=\"").append(this.basePeer).append('\"');
        }
        result.append(">\n");
        if (this.columnList != null) {
            iter = this.columnList.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        if (this.foreignKeys != null) {
            iter = this.foreignKeys.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        if (this.idMethodParameters != null) {
            iter = this.idMethodParameters.iterator();
            while (iter.hasNext()) {
                result.append(iter.next());
            }
        }
        result.append("</table>\n");
        return result.toString();
    }

    public List getPrimaryKey() {
        ArrayList<Column> pk = new ArrayList<Column>(this.columnList.size());
        Iterator iter = this.columnList.iterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            if (!col.isPrimaryKey()) continue;
            pk.add(col);
        }
        return pk;
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey().size() > 0;
    }

    public String printPrimaryKey() {
        return this.printList(this.columnList);
    }

    private String printList(List list) {
        StringBuffer result = new StringBuffer();
        boolean comma = false;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            if (!col.isPrimaryKey()) continue;
            if (comma) {
                result.append(',');
            } else {
                comma = true;
            }
            result.append(col.getName());
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

