/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.Hashtable;

public class TypeMap {
    public static final String CHAR = "CHAR";
    public static final String VARCHAR = "VARCHAR";
    public static final String LONGVARCHAR = "LONGVARCHAR";
    public static final String CLOB = "CLOB";
    public static final String NUMERIC = "NUMERIC";
    public static final String DECIMAL = "DECIMAL";
    public static final String BIT = "BIT";
    public static final String TINYINT = "TINYINT";
    public static final String SMALLINT = "SMALLINT";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String REAL = "REAL";
    public static final String FLOAT = "FLOAT";
    public static final String DOUBLE = "DOUBLE";
    public static final String BINARY = "BINARY";
    public static final String VARBINARY = "VARBINARY";
    public static final String LONGVARBINARY = "LONGVARBINARY";
    public static final String BLOB = "BLOB";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String BOOLEANCHAR = "BOOLEANCHAR";
    public static final String BOOLEANINT = "BOOLEANINT";
    private static final String[] TEXT_TYPES = new String[]{"CHAR", "VARCHAR", "LONGVARCHAR", "CLOB", "DATE", "TIME", "TIMESTAMP", "BOOLEANCHAR"};
    public static final String CHAR_OBJECT_TYPE = "\"\"";
    public static final String VARCHAR_OBJECT_TYPE = "\"\"";
    public static final String LONGVARCHAR_OBJECT_TYPE = "\"\"";
    public static final String CLOB_OBJECT_TYPE = "\"\"";
    public static final String NUMERIC_OBJECT_TYPE = "new BigDecimal(0)";
    public static final String DECIMAL_OBJECT_TYPE = "new BigDecimal(0)";
    public static final String BIT_OBJECT_TYPE = "Boolean.TRUE";
    public static final String TINYINT_OBJECT_TYPE = "new Byte((byte)0)";
    public static final String SMALLINT_OBJECT_TYPE = "new Short((short)0)";
    public static final String INTEGER_OBJECT_TYPE = "new Integer(0)";
    public static final String BIGINT_OBJECT_TYPE = "new Long(0)";
    public static final String REAL_OBJECT_TYPE = "new Float(0)";
    public static final String FLOAT_OBJECT_TYPE = "new Double(0)";
    public static final String DOUBLE_OBJECT_TYPE = "new Double(0)";
    public static final String BINARY_OBJECT_TYPE = "new Object()";
    public static final String VARBINARY_OBJECT_TYPE = "new Object()";
    public static final String LONGVARBINARY_OBJECT_TYPE = "new Object()";
    public static final String BLOB_OBJECT_TYPE = "new Object()";
    public static final String DATE_OBJECT_TYPE = "new Date()";
    public static final String TIME_OBJECT_TYPE = "new Date()";
    public static final String TIMESTAMP_OBJECT_TYPE = "new Date()";
    public static final String BOOLEANCHAR_OBJECT_TYPE = "\"\"";
    public static final String BOOLEANINT_OBJECT_TYPE = "new Integer(0)";
    public static final String CHAR_NATIVE_TYPE = "String";
    public static final String VARCHAR_NATIVE_TYPE = "String";
    public static final String LONGVARCHAR_NATIVE_TYPE = "String";
    public static final String CLOB_NATIVE_TYPE = "String";
    public static final String NUMERIC_NATIVE_TYPE = "BigDecimal";
    public static final String DECIMAL_NATIVE_TYPE = "BigDecimal";
    public static final String BIT_NATIVE_TYPE = "boolean";
    public static final String TINYINT_NATIVE_TYPE = "byte";
    public static final String SMALLINT_NATIVE_TYPE = "short";
    public static final String INTEGER_NATIVE_TYPE = "int";
    public static final String BIGINT_NATIVE_TYPE = "long";
    public static final String REAL_NATIVE_TYPE = "float";
    public static final String FLOAT_NATIVE_TYPE = "double";
    public static final String DOUBLE_NATIVE_TYPE = "double";
    public static final String BINARY_NATIVE_TYPE = "byte[]";
    public static final String VARBINARY_NATIVE_TYPE = "byte[]";
    public static final String LONGVARBINARY_NATIVE_TYPE = "byte[]";
    public static final String BLOB_NATIVE_TYPE = "byte[]";
    public static final String DATE_NATIVE_TYPE = "Date";
    public static final String TIME_NATIVE_TYPE = "Date";
    public static final String TIMESTAMP_NATIVE_TYPE = "Date";
    public static final String BOOLEANCHAR_NATIVE_TYPE = "boolean";
    public static final String BOOLEANINT_NATIVE_TYPE = "boolean";
    public static final String BIT_NATIVE_OBJECT_TYPE = "Boolean";
    public static final String TINYINT_NATIVE_OBJECT_TYPE = "Byte";
    public static final String SMALLINT_NATIVE_OBJECT_TYPE = "Short";
    public static final String INTEGER_NATIVE_OBJECT_TYPE = "Integer";
    public static final String BIGINT_NATIVE_OBJECT_TYPE = "Long";
    public static final String REAL_NATIVE_OBJECT_TYPE = "Float";
    public static final String FLOAT_NATIVE_OBJECT_TYPE = "Double";
    public static final String DOUBLE_NATIVE_OBJECT_TYPE = "Double";
    public static final String BOOLEANCHAR_NATIVE_OBJECT_TYPE = "Boolean";
    public static final String BOOLEANINT_NATIVE_OBJECT_TYPE = "Boolean";
    public static final String CHAR_VILLAGE_METHOD = "asString()";
    public static final String VARCHAR_VILLAGE_METHOD = "asString()";
    public static final String LONGVARCHAR_VILLAGE_METHOD = "asString()";
    public static final String CLOB_VILLAGE_METHOD = "asString()";
    public static final String NUMERIC_VILLAGE_METHOD = "asBigDecimal()";
    public static final String DECIMAL_VILLAGE_METHOD = "asBigDecimal()";
    public static final String BIT_VILLAGE_METHOD = "asBoolean()";
    public static final String TINYINT_VILLAGE_METHOD = "asByte()";
    public static final String SMALLINT_VILLAGE_METHOD = "asShort()";
    public static final String INTEGER_VILLAGE_METHOD = "asInt()";
    public static final String BIGINT_VILLAGE_METHOD = "asLong()";
    public static final String REAL_VILLAGE_METHOD = "asFloat()";
    public static final String FLOAT_VILLAGE_METHOD = "asDouble()";
    public static final String DOUBLE_VILLAGE_METHOD = "asDouble()";
    public static final String BINARY_VILLAGE_METHOD = "asBytes()";
    public static final String VARBINARY_VILLAGE_METHOD = "asBytes()";
    public static final String LONGVARBINARY_VILLAGE_METHOD = "asBytes()";
    public static final String BLOB_VILLAGE_METHOD = "asBytes()";
    public static final String DATE_VILLAGE_METHOD = "asUtilDate()";
    public static final String TIME_VILLAGE_METHOD = "asUtilDate()";
    public static final String TIMESTAMP_VILLAGE_METHOD = "asUtilDate()";
    public static final String BOOLEANCHAR_VILLAGE_METHOD = "asBoolean()";
    public static final String BOOLEANINT_VILLAGE_METHOD = "asBoolean()";
    public static final String BIT_VILLAGE_OBJECT_METHOD = "asBooleanObj()";
    public static final String TINYINT_VILLAGE_OBJECT_METHOD = "asByteObj()";
    public static final String SMALLINT_VILLAGE_OBJECT_METHOD = "asShortObj()";
    public static final String INTEGER_VILLAGE_OBJECT_METHOD = "asIntegerObj()";
    public static final String BIGINT_VILLAGE_OBJECT_METHOD = "asLongObj()";
    public static final String REAL_VILLAGE_OBJECT_METHOD = "asFloatObj()";
    public static final String FLOAT_VILLAGE_OBJECT_METHOD = "asDoubleObj()";
    public static final String DOUBLE_VILLAGE_OBJECT_METHOD = "asDoubleObj()";
    public static final String BOOLEANCHAR_VILLAGE_OBJECT_METHOD = "asBooleanObj()";
    public static final String BOOLEANINT_VILLAGE_OBJECT_METHOD = "asBooleanObj()";
    public static final String CHAR_PP_METHOD = "getString(ppKey)";
    public static final String VARCHAR_PP_METHOD = "getString(ppKey)";
    public static final String LONGVARCHAR_PP_METHOD = "getString(ppKey)";
    public static final String NUMERIC_PP_METHOD = "getBigDecimal(ppKey)";
    public static final String DECIMAL_PP_METHOD = "getBigDecimal(ppKey)";
    public static final String BIT_PP_METHOD = "getBoolean(ppKey)";
    public static final String TINYINT_PP_METHOD = "getByte(ppKey)";
    public static final String SMALLINT_PP_METHOD = "getShort(ppKey)";
    public static final String INTEGER_PP_METHOD = "getInt(ppKey)";
    public static final String BIGINT_PP_METHOD = "getLong(ppKey)";
    public static final String REAL_PP_METHOD = "getFloat(ppKey)";
    public static final String FLOAT_PP_METHOD = "getDouble(ppKey)";
    public static final String DOUBLE_PP_METHOD = "getDouble(ppKey)";
    public static final String BINARY_PP_METHOD = "getBytes(ppKey)";
    public static final String VARBINARY_PP_METHOD = "getBytes(ppKey)";
    public static final String LONGVARBINARY_PP_METHOD = "getBytes(ppKey)";
    public static final String DATE_PP_METHOD = "getDate(ppKey)";
    public static final String TIME_PP_METHOD = "getDate(ppKey)";
    public static final String TIMESTAMP_PP_METHOD = "getDate(ppKey)";
    public static final String BOOLEANCHAR_PP_METHOD = "getBoolean(ppKey)";
    public static final String BOOLEANINT_PP_METHOD = "getBoolean(ppKey)";
    private static Hashtable jdbcToJavaObjectMap = null;
    private static Hashtable jdbcToJavaNativeMap = null;
    private static Hashtable jdbcToJavaNativeObjectMap = null;
    private static Hashtable jdbcToVillageMethodMap = null;
    private static Hashtable jdbcToVillageObjectMethodMap = null;
    private static Hashtable jdbcToPPMethodMap = null;
    private static Hashtable torqueTypeToJdbcTypeMap = null;
    private static Hashtable jdbcToTorqueTypeMap = null;
    private static boolean isInitialized = false;

    public static synchronized void initialize() {
        if (!isInitialized) {
            jdbcToJavaObjectMap = new Hashtable();
            jdbcToJavaObjectMap.put(CHAR, "\"\"");
            jdbcToJavaObjectMap.put(VARCHAR, "\"\"");
            jdbcToJavaObjectMap.put(LONGVARCHAR, "\"\"");
            jdbcToJavaObjectMap.put(CLOB, "\"\"");
            jdbcToJavaObjectMap.put(NUMERIC, "new BigDecimal(0)");
            jdbcToJavaObjectMap.put(DECIMAL, "new BigDecimal(0)");
            jdbcToJavaObjectMap.put(BIT, BIT_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(TINYINT, TINYINT_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(SMALLINT, SMALLINT_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(INTEGER, "new Integer(0)");
            jdbcToJavaObjectMap.put(BIGINT, BIGINT_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(REAL, REAL_OBJECT_TYPE);
            jdbcToJavaObjectMap.put(FLOAT, "new Double(0)");
            jdbcToJavaObjectMap.put(DOUBLE, "new Double(0)");
            jdbcToJavaObjectMap.put(BINARY, "new Object()");
            jdbcToJavaObjectMap.put(VARBINARY, "new Object()");
            jdbcToJavaObjectMap.put(LONGVARBINARY, "new Object()");
            jdbcToJavaObjectMap.put(BLOB, "new Object()");
            jdbcToJavaObjectMap.put(DATE, "new Date()");
            jdbcToJavaObjectMap.put(TIME, "new Date()");
            jdbcToJavaObjectMap.put(TIMESTAMP, "new Date()");
            jdbcToJavaObjectMap.put(BOOLEANCHAR, "\"\"");
            jdbcToJavaObjectMap.put(BOOLEANINT, "new Integer(0)");
            jdbcToJavaNativeMap = new Hashtable();
            jdbcToJavaNativeMap.put(CHAR, "String");
            jdbcToJavaNativeMap.put(VARCHAR, "String");
            jdbcToJavaNativeMap.put(LONGVARCHAR, "String");
            jdbcToJavaNativeMap.put(CLOB, "String");
            jdbcToJavaNativeMap.put(NUMERIC, "BigDecimal");
            jdbcToJavaNativeMap.put(DECIMAL, "BigDecimal");
            jdbcToJavaNativeMap.put(BIT, "boolean");
            jdbcToJavaNativeMap.put(TINYINT, TINYINT_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(SMALLINT, SMALLINT_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(INTEGER, INTEGER_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(BIGINT, BIGINT_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(REAL, REAL_NATIVE_TYPE);
            jdbcToJavaNativeMap.put(FLOAT, "double");
            jdbcToJavaNativeMap.put(DOUBLE, "double");
            jdbcToJavaNativeMap.put(BINARY, "byte[]");
            jdbcToJavaNativeMap.put(VARBINARY, "byte[]");
            jdbcToJavaNativeMap.put(LONGVARBINARY, "byte[]");
            jdbcToJavaNativeMap.put(BLOB, "byte[]");
            jdbcToJavaNativeMap.put(DATE, "Date");
            jdbcToJavaNativeMap.put(TIME, "Date");
            jdbcToJavaNativeMap.put(TIMESTAMP, "Date");
            jdbcToJavaNativeMap.put(BOOLEANCHAR, "boolean");
            jdbcToJavaNativeMap.put(BOOLEANINT, "boolean");
            jdbcToJavaNativeObjectMap = new Hashtable();
            jdbcToJavaNativeObjectMap.put(BIT, "Boolean");
            jdbcToJavaNativeObjectMap.put(TINYINT, TINYINT_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(SMALLINT, SMALLINT_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(INTEGER, INTEGER_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(BIGINT, BIGINT_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(REAL, REAL_NATIVE_OBJECT_TYPE);
            jdbcToJavaNativeObjectMap.put(FLOAT, "Double");
            jdbcToJavaNativeObjectMap.put(DOUBLE, "Double");
            jdbcToJavaNativeObjectMap.put(BOOLEANCHAR, "Boolean");
            jdbcToJavaNativeObjectMap.put(BOOLEANINT, "Boolean");
            jdbcToVillageMethodMap = new Hashtable();
            jdbcToVillageMethodMap.put(CHAR, "asString()");
            jdbcToVillageMethodMap.put(VARCHAR, "asString()");
            jdbcToVillageMethodMap.put(LONGVARCHAR, "asString()");
            jdbcToVillageMethodMap.put(CLOB, "asString()");
            jdbcToVillageMethodMap.put(NUMERIC, "asBigDecimal()");
            jdbcToVillageMethodMap.put(DECIMAL, "asBigDecimal()");
            jdbcToVillageMethodMap.put(BIT, "asBoolean()");
            jdbcToVillageMethodMap.put(TINYINT, TINYINT_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(SMALLINT, SMALLINT_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(INTEGER, INTEGER_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(BIGINT, BIGINT_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(REAL, REAL_VILLAGE_METHOD);
            jdbcToVillageMethodMap.put(FLOAT, "asDouble()");
            jdbcToVillageMethodMap.put(DOUBLE, "asDouble()");
            jdbcToVillageMethodMap.put(BINARY, "asBytes()");
            jdbcToVillageMethodMap.put(VARBINARY, "asBytes()");
            jdbcToVillageMethodMap.put(LONGVARBINARY, "asBytes()");
            jdbcToVillageMethodMap.put(BLOB, "asBytes()");
            jdbcToVillageMethodMap.put(DATE, "asUtilDate()");
            jdbcToVillageMethodMap.put(TIME, "asUtilDate()");
            jdbcToVillageMethodMap.put(TIMESTAMP, "asUtilDate()");
            jdbcToVillageMethodMap.put(BOOLEANCHAR, "asBoolean()");
            jdbcToVillageMethodMap.put(BOOLEANINT, "asBoolean()");
            jdbcToVillageObjectMethodMap = new Hashtable();
            jdbcToVillageObjectMethodMap.put(BIT, "asBooleanObj()");
            jdbcToVillageObjectMethodMap.put(TINYINT, TINYINT_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(SMALLINT, SMALLINT_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(INTEGER, INTEGER_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(BIGINT, BIGINT_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(REAL, REAL_VILLAGE_OBJECT_METHOD);
            jdbcToVillageObjectMethodMap.put(FLOAT, "asDoubleObj()");
            jdbcToVillageObjectMethodMap.put(DOUBLE, "asDoubleObj()");
            jdbcToVillageObjectMethodMap.put(BOOLEANCHAR, "asBooleanObj()");
            jdbcToVillageObjectMethodMap.put(BOOLEANINT, "asBooleanObj()");
            jdbcToPPMethodMap = new Hashtable();
            jdbcToPPMethodMap.put(CHAR, "getString(ppKey)");
            jdbcToPPMethodMap.put(VARCHAR, "getString(ppKey)");
            jdbcToPPMethodMap.put(LONGVARCHAR, "getString(ppKey)");
            jdbcToPPMethodMap.put(NUMERIC, "getBigDecimal(ppKey)");
            jdbcToPPMethodMap.put(DECIMAL, "getBigDecimal(ppKey)");
            jdbcToPPMethodMap.put(BIT, "getBoolean(ppKey)");
            jdbcToPPMethodMap.put(TINYINT, TINYINT_PP_METHOD);
            jdbcToPPMethodMap.put(SMALLINT, SMALLINT_PP_METHOD);
            jdbcToPPMethodMap.put(INTEGER, INTEGER_PP_METHOD);
            jdbcToPPMethodMap.put(BIGINT, BIGINT_PP_METHOD);
            jdbcToPPMethodMap.put(REAL, REAL_PP_METHOD);
            jdbcToPPMethodMap.put(FLOAT, "getDouble(ppKey)");
            jdbcToPPMethodMap.put(DOUBLE, "getDouble(ppKey)");
            jdbcToPPMethodMap.put(BINARY, "getBytes(ppKey)");
            jdbcToPPMethodMap.put(VARBINARY, "getBytes(ppKey)");
            jdbcToPPMethodMap.put(LONGVARBINARY, "getBytes(ppKey)");
            jdbcToPPMethodMap.put(DATE, "getDate(ppKey)");
            jdbcToPPMethodMap.put(TIME, "getDate(ppKey)");
            jdbcToPPMethodMap.put(TIMESTAMP, "getDate(ppKey)");
            jdbcToPPMethodMap.put(BOOLEANCHAR, "getBoolean(ppKey)");
            jdbcToPPMethodMap.put(BOOLEANINT, "getBoolean(ppKey)");
            torqueTypeToJdbcTypeMap = new Hashtable();
            torqueTypeToJdbcTypeMap.put(CHAR, CHAR);
            torqueTypeToJdbcTypeMap.put(VARCHAR, VARCHAR);
            torqueTypeToJdbcTypeMap.put(LONGVARCHAR, LONGVARCHAR);
            torqueTypeToJdbcTypeMap.put(CLOB, CLOB);
            torqueTypeToJdbcTypeMap.put(NUMERIC, NUMERIC);
            torqueTypeToJdbcTypeMap.put(DECIMAL, DECIMAL);
            torqueTypeToJdbcTypeMap.put(BIT, BIT);
            torqueTypeToJdbcTypeMap.put(TINYINT, TINYINT);
            torqueTypeToJdbcTypeMap.put(SMALLINT, SMALLINT);
            torqueTypeToJdbcTypeMap.put(INTEGER, INTEGER);
            torqueTypeToJdbcTypeMap.put(BIGINT, BIGINT);
            torqueTypeToJdbcTypeMap.put(REAL, REAL);
            torqueTypeToJdbcTypeMap.put(FLOAT, FLOAT);
            torqueTypeToJdbcTypeMap.put(DOUBLE, DOUBLE);
            torqueTypeToJdbcTypeMap.put(BINARY, BINARY);
            torqueTypeToJdbcTypeMap.put(VARBINARY, VARBINARY);
            torqueTypeToJdbcTypeMap.put(LONGVARBINARY, LONGVARBINARY);
            torqueTypeToJdbcTypeMap.put(BLOB, BLOB);
            torqueTypeToJdbcTypeMap.put(DATE, DATE);
            torqueTypeToJdbcTypeMap.put(TIME, TIME);
            torqueTypeToJdbcTypeMap.put(TIMESTAMP, TIMESTAMP);
            torqueTypeToJdbcTypeMap.put(BOOLEANCHAR, CHAR);
            torqueTypeToJdbcTypeMap.put(BOOLEANINT, INTEGER);
            jdbcToTorqueTypeMap = new Hashtable();
            jdbcToTorqueTypeMap.put(new Integer(1), CHAR);
            jdbcToTorqueTypeMap.put(new Integer(12), VARCHAR);
            jdbcToTorqueTypeMap.put(new Integer(-1), LONGVARCHAR);
            jdbcToTorqueTypeMap.put(new Integer(2005), CLOB);
            jdbcToTorqueTypeMap.put(new Integer(2), NUMERIC);
            jdbcToTorqueTypeMap.put(new Integer(3), DECIMAL);
            jdbcToTorqueTypeMap.put(new Integer(-7), BIT);
            jdbcToTorqueTypeMap.put(new Integer(-6), TINYINT);
            jdbcToTorqueTypeMap.put(new Integer(5), SMALLINT);
            jdbcToTorqueTypeMap.put(new Integer(4), INTEGER);
            jdbcToTorqueTypeMap.put(new Integer(-5), BIGINT);
            jdbcToTorqueTypeMap.put(new Integer(7), REAL);
            jdbcToTorqueTypeMap.put(new Integer(6), FLOAT);
            jdbcToTorqueTypeMap.put(new Integer(8), DOUBLE);
            jdbcToTorqueTypeMap.put(new Integer(-2), BINARY);
            jdbcToTorqueTypeMap.put(new Integer(-3), VARBINARY);
            jdbcToTorqueTypeMap.put(new Integer(-4), LONGVARBINARY);
            jdbcToTorqueTypeMap.put(new Integer(2004), BLOB);
            jdbcToTorqueTypeMap.put(new Integer(91), DATE);
            jdbcToTorqueTypeMap.put(new Integer(92), TIME);
            jdbcToTorqueTypeMap.put(new Integer(93), TIMESTAMP);
            isInitialized = true;
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static String getJavaObject(String jdbcType) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)jdbcToJavaObjectMap.get(jdbcType);
    }

    public static String getJavaNative(String jdbcType) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)jdbcToJavaNativeMap.get(jdbcType);
    }

    public static String getJavaNativeObject(String jdbcType) {
        String s;
        if (!isInitialized) {
            TypeMap.initialize();
        }
        if ((s = (String)jdbcToJavaNativeObjectMap.get(jdbcType)) == null) {
            s = (String)jdbcToJavaNativeMap.get(jdbcType);
        }
        return s;
    }

    public static String getVillageMethod(String jdbcType) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)jdbcToVillageMethodMap.get(jdbcType);
    }

    public static String getVillageObjectMethod(String jdbcType) {
        String s;
        if (!isInitialized) {
            TypeMap.initialize();
        }
        if ((s = (String)jdbcToVillageObjectMethodMap.get(jdbcType)) == null) {
            s = (String)jdbcToVillageMethodMap.get(jdbcType);
        }
        return s;
    }

    public static String getPPMethod(String jdbcType) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)jdbcToPPMethodMap.get(jdbcType);
    }

    public static String getJdbcType(String type) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)torqueTypeToJdbcTypeMap.get(type);
    }

    public static String getTorqueType(Integer sqlType) {
        if (!isInitialized) {
            TypeMap.initialize();
        }
        return (String)jdbcToTorqueTypeMap.get(sqlType);
    }

    public static boolean isBooleanInt(String type) {
        return BOOLEANINT.equals(type);
    }

    public static boolean isBooleanChar(String type) {
        return BOOLEANCHAR.equals(type);
    }

    public static boolean isBit(String type) {
        return BIT.equals(type);
    }

    public static final boolean isTextType(String type) {
        for (int i = 0; i < TEXT_TYPES.length; ++i) {
            if (!type.equals(TEXT_TYPES[i])) continue;
            return true;
        }
        return false;
    }
}

